/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.ProjectVersionEnforcingState;
import org.commonjava.maven.ext.core.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="enforce-project-version")
@Singleton
public class ProjectVersionEnforcingManipulator
implements Manipulator {
    private static final String PROJVER = "${project.version}";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new ProjectVersionEnforcingState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) {
        ProjectVersionEnforcingState state = this.session.getState(ProjectVersionEnforcingState.class);
        if (!(this.session.isEnabled() && this.session.anyStateEnabled(State.activeByDefault) && state != null && state.isEnabled())) {
            this.logger.debug("Project version enforcement is disabled.");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            List<Profile> profiles;
            Model model = project.getModel();
            if (!model.getPackaging().equals("pom")) continue;
            this.enforceProjectVersion(project, model.getDependencies(), changed);
            if (model.getDependencyManagement() != null) {
                this.enforceProjectVersion(project, model.getDependencyManagement().getDependencies(), changed);
            }
            if ((profiles = ProfileUtils.getProfiles(this.session, model)) == null) continue;
            for (Profile profile : profiles) {
                this.enforceProjectVersion(project, profile.getDependencies(), changed);
                if (profile.getDependencyManagement() == null) continue;
                this.enforceProjectVersion(project, profile.getDependencyManagement().getDependencies(), changed);
            }
        }
        if (!changed.isEmpty()) {
            this.logger.warn("Using ${project.version} in pom files may lead to unexpected errors with inheritance.");
        }
        return changed;
    }

    private void enforceProjectVersion(Project project, List<Dependency> dependencies, Set<Project> changed) {
        String newVersion = project.getVersion();
        dependencies.stream().filter(d -> PROJVER.equals(d.getVersion())).forEach(d -> {
            this.logger.debug("Replacing project.version within {} for project {} with {}", d, project, newVersion);
            d.setVersion(newVersion);
            changed.add(project);
        });
    }

    @Override
    public int getExecutionIndex() {
        return 70;
    }
}

