/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.maven.io.util.DocumentModifier;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.jdom.MavenJDOMWriter;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.GAV;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ManifestUtils;
import org.commonjava.maven.galley.maven.parse.PomPeek;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.filter.ContentFilter;
import org.jdom2.output.LineSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class PomIO {
    private static final String MODIFIED_BY = "Modified by POM Manipulation Extension for Maven";
    private static final Logger logger = LoggerFactory.getLogger(PomIO.class);

    public List<Project> parseProject(File pom) throws ManipulationException {
        List<PomPeek> peeked = this.peekAtPomHierarchy(pom);
        return this.readModelsForManipulation(pom.getAbsoluteFile(), peeked);
    }

    private List<Project> readModelsForManipulation(File executionRoot, List<PomPeek> peeked) throws ManipulationException {
        ArrayList<Project> projects = new ArrayList<Project>();
        HashMap<Project, ProjectVersionRef> projectToParent = new HashMap<Project, ProjectVersionRef>();
        for (PomPeek peek : peeked) {
            Model raw;
            File pom = peek.getPom();
            try (FileInputStream in = new FileInputStream(pom);){
                raw = new MavenXpp3Reader().read(in);
            }
            catch (IOException | XmlPullParserException e) {
                throw new ManipulationException("Failed to build model for POM: %s.\n--> %s", (Throwable)e, pom, e.getMessage());
            }
            if (raw == null) continue;
            Project project = new Project(pom, raw);
            projectToParent.put(project, peek.getParentKey());
            project.setInheritanceRoot(peek.isInheritanceRoot());
            if (executionRoot.equals(pom)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting execution root to {} with file {}" + (project.isInheritanceRoot() ? " and is the inheritance root. " : ""), (Object)project, (Object)pom);
                }
                project.setExecutionRoot();
                try {
                    if (FileUtils.readFileToString(pom).contains(MODIFIED_BY)) {
                        project.setIncrementalPME(true);
                    }
                }
                catch (IOException e) {
                    throw new ManipulationException("Failed to read POM: %s", (Throwable)e, pom);
                }
            }
            projects.add(project);
        }
        for (Project p : projects) {
            ProjectVersionRef pvr = (ProjectVersionRef)projectToParent.get(p);
            p.setProjectParent(this.getParent(projects, pvr));
        }
        return projects;
    }

    private Project getParent(List<Project> projects, ProjectVersionRef pvr) {
        for (Project p : projects) {
            if (!p.getKey().equals(pvr)) continue;
            return p;
        }
        return null;
    }

    public GAV rewritePOMs(Set<Project> changed) throws ManipulationException {
        GAV result = null;
        for (Project project : changed) {
            if (project.isExecutionRoot()) {
                result = new GAV(project.getKey());
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("%s modified! Rewriting.", project));
            }
            File pom = project.getPom();
            Model model = project.getModel();
            logger.trace("Rewriting: {} in place of: {}\n       to POM: {}", model.getId(), project.getKey(), pom);
            this.write(project, pom, model);
            if (!pom.getName().equals("interpolated-pom.xml")) continue;
            File dir = pom.getParentFile();
            pom = dir == null ? new File("pom.xml") : new File(dir, "pom.xml");
            this.write(project, pom, model);
        }
        return result;
    }

    public void writeModel(Model model, File target) throws ManipulationException {
        try {
            new MavenXpp3Writer().write(new FileWriter(target), model);
        }
        catch (IOException e) {
            throw new ManipulationException("Unable to write file", (Throwable)e, new Object[0]);
        }
    }

    private void write(final Project project, File pom, Model model) throws ManipulationException {
        try {
            final String manifestInformation = project.isInheritanceRoot() ? ManifestUtils.getManifestInformation() : null;
            MavenJDOMWriter mjw = new MavenJDOMWriter(model);
            LineSeparator ls = PomIO.determineEOL(pom);
            mjw.setLineSeparator(ls);
            mjw.write(model, pom, new DocumentModifier(){

                @Override
                public void postProcess(Document doc) {
                    if (project.isExecutionRoot()) {
                        Iterator<Content> it = doc.getContent(new ContentFilter(8)).iterator();
                        while (it.hasNext()) {
                            Comment c = (Comment)it.next();
                            if (!c.toString().contains(PomIO.MODIFIED_BY)) continue;
                            it.remove();
                        }
                        doc.addContent(Collections.singletonList(new Comment("\nModified by POM Manipulation Extension for Maven " + manifestInformation + "\n")));
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ManipulationException("Failed to read POM for rewrite: %s. Reason: %s", (Throwable)e, pom, e.getMessage());
        }
        catch (JDOMException e) {
            throw new ManipulationException("Failed to parse POM for rewrite: %s. Reason: %s", (Throwable)e, pom, e.getMessage());
        }
    }

    private List<PomPeek> peekAtPomHierarchy(File topPom) throws ManipulationException {
        ArrayList<PomPeek> peeked = new ArrayList<PomPeek>();
        try {
            LinkedList<File> pendingPoms = new LinkedList<File>();
            pendingPoms.add(topPom.getCanonicalFile());
            String topDir = topPom.getAbsoluteFile().getParentFile().getCanonicalPath();
            HashSet<File> seen = new HashSet<File>();
            File topLevelParent = topPom;
            while (!pendingPoms.isEmpty()) {
                File pom = (File)pendingPoms.removeFirst();
                seen.add(pom);
                logger.debug("PEEK: {}", (Object)pom);
                PomPeek peek = new PomPeek(pom);
                ProjectVersionRef key = peek.getKey();
                if (key != null) {
                    Set<String> modules;
                    peeked.add(peek);
                    File dir = pom.getParentFile();
                    String relPath = peek.getParentRelativePath();
                    if (relPath != null) {
                        logger.debug("Found parent relativePath: {} in pom: {}", (Object)relPath, (Object)pom);
                        File parent = new File(dir, relPath);
                        if (parent.isDirectory()) {
                            parent = new File(parent, "pom.xml");
                        }
                        if ((parent = parent.getCanonicalFile()).getParentFile().getCanonicalPath().startsWith(topDir) && parent.exists() && !seen.contains(parent) && !pendingPoms.contains(parent)) {
                            topLevelParent = parent;
                            logger.debug("Possible top level parent {}", (Object)parent);
                            pendingPoms.add(parent);
                        } else {
                            logger.debug("Skipping reference to non-existent parent relativePath: '{}' in: {}", (Object)relPath, (Object)pom);
                        }
                    }
                    if ((modules = peek.getModules()) == null || modules.isEmpty()) continue;
                    for (String module : modules) {
                        File modPom;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found module: {} in pom: {}", (Object)module, (Object)pom);
                        }
                        if ((modPom = new File(dir, module)).isDirectory()) {
                            modPom = new File(modPom, "pom.xml");
                        }
                        if (modPom.exists() && !seen.contains(modPom) && !pendingPoms.contains(modPom)) {
                            pendingPoms.addLast(modPom);
                            continue;
                        }
                        logger.debug("Skipping reference to non-existent module: '{}' in: {}", (Object)module, (Object)pom);
                    }
                    continue;
                }
                logger.debug("Skipping {} as its a template file.", (Object)pom);
            }
            HashSet<ProjectVersionRef> projectrefs = new HashSet<ProjectVersionRef>();
            for (PomPeek p : peeked) {
                projectrefs.add(p.getKey());
                if (!p.getPom().equals(topLevelParent)) continue;
                logger.debug("Setting top level parent to {} :: {}", (Object)p.getPom(), (Object)p.getKey());
                p.setInheritanceRoot(true);
            }
            for (PomPeek p : peeked) {
                if (p.getParentKey() != null && this.seenThisParent(projectrefs, p.getParentKey())) continue;
                logger.debug("Found a standalone pom {} :: {}", (Object)p.getPom(), (Object)p.getKey());
                p.setInheritanceRoot(true);
            }
        }
        catch (IOException e) {
            throw new ManipulationException("Problem peeking at POMs.", (Throwable)e, new Object[0]);
        }
        return peeked;
    }

    private boolean seenThisParent(HashSet<ProjectVersionRef> projectrefs, ProjectVersionRef parentKey) {
        for (ProjectVersionRef p : projectrefs) {
            if (!p.versionlessEquals(parentKey)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LineSeparator determineEOL(File pom) throws ManipulationException {
        try (BufferedInputStream bufferIn = new BufferedInputStream(new FileInputStream(pom));){
            int ch;
            int prev = -1;
            while ((ch = bufferIn.read()) != -1) {
                if (ch == 10) {
                    if (prev == 13) {
                        LineSeparator lineSeparator = LineSeparator.CRNL;
                        return lineSeparator;
                    }
                    LineSeparator lineSeparator = LineSeparator.NL;
                    return lineSeparator;
                }
                if (prev == 13) {
                    LineSeparator lineSeparator = LineSeparator.CR;
                    return lineSeparator;
                }
                prev = ch;
            }
            throw new ManipulationException("Could not determine end-of-line marker mode", new String[0]);
        }
        catch (IOException ioe) {
            throw new ManipulationException("Could not determine end-of-line marker mode", (Throwable)ioe, new Object[0]);
        }
    }
}

