/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.commonjava.maven.galley.io.SpecialPathSet;
import org.commonjava.maven.galley.model.FilePatternMatcher;
import org.commonjava.maven.galley.model.SpecialPathInfo;

class MavenSpecialPathSet
implements SpecialPathSet {
    final List<SpecialPathInfo> mvnSpecialPaths = new ArrayList<SpecialPathInfo>();

    MavenSpecialPathSet() {
        this.mvnSpecialPaths.add(SpecialPathInfo.from(new FilePatternMatcher("maven-metadata\\.xml$")).setMergable(true).setMetadata(true).build());
        this.mvnSpecialPaths.add(SpecialPathInfo.from(new FilePatternMatcher("maven-metadata\\.xml(\\.md5|\\.sha[\\d]+)$")).setDecoratable(false).setMergable(true).setMetadata(true).build());
        this.mvnSpecialPaths.add(SpecialPathInfo.from(new FilePatternMatcher("archetype-catalog\\.xml$")).setMergable(true).setMetadata(true).build());
        this.mvnSpecialPaths.add(SpecialPathInfo.from(new FilePatternMatcher("archetype-catalog\\.xml(\\.md5|\\.sha[\\d]+)$")).setDecoratable(false).setMergable(true).setMetadata(true).build());
        String notMergablePrefix = ".+(?<!(maven-metadata|archetype-catalog)\\.xml)\\.";
        for (String extPattern : Arrays.asList("asc$", "md5$", "sha[\\d]+$")) {
            this.mvnSpecialPaths.add(SpecialPathInfo.from(new FilePatternMatcher(notMergablePrefix + extPattern)).setDecoratable(false).build());
        }
    }

    @Override
    public String getPackageType() {
        return "maven";
    }

    @Override
    public List<SpecialPathInfo> getSpecialPathInfos() {
        return this.mvnSpecialPaths;
    }

    @Override
    public synchronized void registerSpecialPathInfo(SpecialPathInfo pathInfo) {
        this.mvnSpecialPaths.add(pathInfo);
    }

    @Override
    public synchronized void deregisterSpecialPathInfo(SpecialPathInfo pathInfo) {
        this.mvnSpecialPaths.remove(pathInfo);
    }
}

