/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io.nocache;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCacheInputStream
extends FilterInputStream {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Transfer transfer;

    public NoCacheInputStream(InputStream stream, Transfer transfer) {
        super(stream);
        this.transfer = transfer;
    }

    @Override
    public void close() throws IOException {
        try {
            this.logger.trace("START CLOSE: {}", (Object)this.transfer);
            super.close();
            this.logger.trace("Delete: {} and its siblings in: {}.", (Object)this.transfer.getPath(), (Object)this.transfer.getLocation());
            this.transfer.delete(false);
            Transfer meta = this.transfer.getSibling(".http-metadata.json");
            if (meta != null && meta.exists()) {
                meta.delete(false);
            }
        }
        finally {
            this.logger.trace("END CLOSE: {}", (Object)this.transfer);
        }
    }
}

