/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.microprofile.client.utils.ListCastUtils;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class HttpHeadersContextProvider
implements HttpHeaders {
    private final ClientRequestContext context;

    public HttpHeadersContextProvider(ClientRequestContext context) {
        this.context = context;
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        MultivaluedMap<String, Object> headers = this.context.getHeaders();
        MultivaluedHashMap<String, String> result = new MultivaluedHashMap<String, String>();
        headers.forEach((key, values) -> result.put((String)key, (String)((Object)ListCastUtils.castToListOfStrings(values))));
        return result;
    }

    @Override
    public List<String> getRequestHeader(String name) {
        List vals = (List)this.getRequestHeaders().get(name);
        if (vals == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(vals);
    }

    @Override
    public Map<String, Cookie> getCookies() {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List cookieHeader = (List)this.getRequestHeaders().get("Cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            for (String s : cookieHeader) {
                List<Cookie> list = CookieParser.parseCookies(s);
                for (Cookie cookie : list) {
                    cookies.put(cookie.getName(), cookie);
                }
            }
        }
        return Collections.unmodifiableMap(cookies);
    }

    @Override
    public Date getDate() {
        String date = this.getRequestHeaders().getFirst("Date");
        return date == null ? null : DateUtil.parseDate(date);
    }

    @Override
    public String getHeaderString(String name) {
        List vals = (List)this.getRequestHeaders().get(name);
        return vals == null ? null : String.join((CharSequence)",", vals);
    }

    @Override
    public Locale getLanguage() {
        String obj = this.getRequestHeaders().getFirst("Content-Language");
        return obj == null ? null : new Locale(obj);
    }

    @Override
    public int getLength() {
        String obj = this.getRequestHeaders().getFirst("Content-Length");
        if (obj == null) {
            return -1;
        }
        return Integer.parseInt(obj);
    }

    @Override
    public MediaType getMediaType() {
        String contentType = this.getRequestHeaders().getFirst("Content-Type");
        return contentType == null ? null : MediaType.valueOf(contentType);
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        String accepts = this.getHeaderString("Accept");
        if (accepts == null) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        return this.parseToStream(accepts).map(MediaType::valueOf).sorted(MediaTypeHelper::compareWeight).collect(Collectors.toList());
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        String accepts = this.getHeaderString("Accept-Language");
        if (accepts == null) {
            return Collections.singletonList(Locale.forLanguageTag("*"));
        }
        return this.parseToStream(accepts).map(WeightedLanguage::parse).sorted().map(WeightedLanguage::getLocale).collect(Collectors.toList());
    }

    private Stream<String> parseToStream(String accepts) {
        String[] splitValues = accepts.split(",");
        return Arrays.stream(splitValues).map(String::trim);
    }
}

