/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTreeEntry;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHTree {
    GHRepository repo;
    private boolean truncated;
    private String sha;
    private String url;
    private GHTreeEntry[] tree;

    public String getSha() {
        return this.sha;
    }

    public List<GHTreeEntry> getTree() {
        return Collections.unmodifiableList(Arrays.asList(this.tree));
    }

    public GHTreeEntry getEntry(String path) {
        for (GHTreeEntry e : this.tree) {
            if (!e.getPath().equals(path)) continue;
            return e;
        }
        return null;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public URL getUrl() {
        return GitHub.parseURL(this.url);
    }

    GHTree wrap(GHRepository repo) {
        this.repo = repo;
        for (GHTreeEntry e : this.tree) {
            e.tree = this;
        }
        return this;
    }
}

