/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoppableRunnable
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean stop = false;
    private Thread myThread;

    public final synchronized void stop() {
        this.logger.debug("setting stop flag on %s", (Object)this);
        this.stop = true;
        if (this.myThread != null) {
            this.logger.debug("interrupting current thread: %s for task: %s", (Object)this.myThread, (Object)this);
            this.myThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (this.stop) {
            this.logger.debug("stopping task: %s", (Object)this);
            return;
        }
        StoppableRunnable stoppableRunnable = this;
        synchronized (stoppableRunnable) {
            this.myThread = Thread.currentThread();
        }
        if (this.myThread.isInterrupted()) {
            return;
        }
        this.doExecute();
        if (this.myThread.isInterrupted()) {
            return;
        }
        stoppableRunnable = this;
        synchronized (stoppableRunnable) {
            this.myThread = null;
        }
    }

    protected abstract void doExecute();
}

