/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.rel;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.commonjava.maven.atlas.graph.rel.AbstractSimpleProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.PluginDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipType;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;

public final class SimplePluginDependencyRelationship
extends AbstractSimpleProjectRelationship<PluginDependencyRelationship, ArtifactRef>
implements Serializable,
PluginDependencyRelationship {
    private static final long serialVersionUID = 1L;
    private final ProjectRef plugin;
    private boolean optional;

    public SimplePluginDependencyRelationship(URI source, ProjectVersionRef declaring, ProjectRef plugin, ArtifactRef target, int index, boolean managed, boolean inherited) {
        super(source, RelationshipType.PLUGIN_DEP, declaring, target, index, managed, inherited, false);
        this.plugin = plugin;
        this.optional = this.optional;
    }

    public SimplePluginDependencyRelationship(URI source, URI pomLocation, ProjectVersionRef declaring, ProjectRef plugin, ArtifactRef target, int index, boolean managed, boolean inherited) {
        super(source, pomLocation, RelationshipType.PLUGIN_DEP, declaring, target, index, managed, inherited, false);
        this.plugin = plugin;
        this.optional = this.optional;
    }

    public SimplePluginDependencyRelationship(Collection<URI> sources, URI pomLocation, ProjectVersionRef declaring, ProjectRef plugin, ArtifactRef target, int index, boolean managed, boolean inherited) {
        super(sources, pomLocation, RelationshipType.PLUGIN_DEP, declaring, target, index, managed, inherited, false);
        this.plugin = plugin;
        this.optional = this.optional;
    }

    public SimplePluginDependencyRelationship(PluginDependencyRelationship relationship) {
        super(relationship);
        this.plugin = new SimpleProjectRef(relationship.getPlugin());
        this.optional = this.optional;
    }

    @Override
    public final ProjectRef getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isManaged() ? 1231 : 1237);
        result = 31 * result + (this.plugin == null ? 0 : this.plugin.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PluginDependencyRelationship)) {
            return false;
        }
        PluginDependencyRelationship other = (PluginDependencyRelationship)obj;
        if (this.isManaged() != other.isManaged()) {
            return false;
        }
        return !(this.plugin == null ? other.getPlugin() != null : !this.plugin.equals(other.getPlugin()));
    }

    public String toString() {
        return String.format("PluginDependencyRelationship [%s -> (%s) => %s (managed=%s, index=%s)]", this.getDeclaring(), this.plugin, this.getTarget(), this.isManaged(), this.getIndex());
    }

    @Override
    protected ArtifactRef cloneTarget(ArtifactRef target) {
        return new SimpleArtifactRef(target);
    }

    @Override
    public ArtifactRef getTargetArtifact() {
        return (ArtifactRef)this.getTarget();
    }

    @Override
    public PluginDependencyRelationship selectDeclaring(ProjectVersionRef ref) {
        ArtifactRef t = (ArtifactRef)this.getTarget();
        return new SimplePluginDependencyRelationship(this.getSources(), this.getPomLocation(), ref, this.getPlugin(), t, this.getIndex(), this.isManaged(), this.isInherited());
    }

    @Override
    public PluginDependencyRelationship selectTarget(ProjectVersionRef ref) {
        ProjectVersionRef d = this.getDeclaring();
        ArtifactRef t = (ArtifactRef)this.getTarget();
        t = (ArtifactRef)(ref instanceof ArtifactRef ? ref : new SimpleArtifactRef(ref, t.getType(), t.getClassifier()));
        return new SimplePluginDependencyRelationship(this.getSources(), this.getPomLocation(), d, this.getPlugin(), t, this.getIndex(), this.isManaged(), this.isInherited());
    }

    @Override
    public synchronized PluginDependencyRelationship cloneFor(ProjectVersionRef projectRef) {
        return new SimplePluginDependencyRelationship(this.getSources(), this.getPomLocation(), projectRef, this.plugin, (ArtifactRef)this.getTarget(), this.getIndex(), this.isManaged(), this.isInherited());
    }

    @Override
    public PluginDependencyRelationship addSource(URI source) {
        Set<URI> srcs = this.getSources();
        srcs.add(source);
        return new SimplePluginDependencyRelationship(srcs, this.getPomLocation(), this.getDeclaring(), this.plugin, (ArtifactRef)this.getTarget(), this.getIndex(), this.isManaged(), this.isInherited());
    }

    @Override
    public PluginDependencyRelationship addSources(Collection<URI> sources) {
        Set<URI> srcs = this.getSources();
        srcs.addAll(sources);
        return new SimplePluginDependencyRelationship(srcs, this.getPomLocation(), this.getDeclaring(), this.plugin, (ArtifactRef)this.getTarget(), this.getIndex(), this.isManaged(), this.isInherited());
    }
}

