/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import org.commonjava.maven.atlas.graph.rel.DependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.ParentRelationship;
import org.commonjava.maven.atlas.graph.rel.ProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipConstants;
import org.commonjava.maven.atlas.graph.rel.SimpleDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleParentRelationship;
import org.commonjava.maven.atlas.ident.DependencyScope;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.util.IdentityUtils;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;

public final class RelationshipUtils {
    public static DependencyRelationship dependency(URI source, ProjectVersionRef owner, String groupId, String artifactId, String version, int index, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return RelationshipUtils.dependency(source, owner, groupId, artifactId, version, null, null, optional, null, index, false, inherited);
    }

    public static DependencyRelationship dependency(URI source, ProjectVersionRef owner, ProjectVersionRef dep, int index, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return RelationshipUtils.dependency(source, owner, dep, null, null, optional, null, index, false, inherited);
    }

    public static DependencyRelationship dependency(URI source, ProjectVersionRef owner, String groupId, String artifactId, String version, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return RelationshipUtils.dependency(source, owner, groupId, artifactId, version, null, null, optional, scope, index, managed, inherited);
    }

    public static DependencyRelationship dependency(URI source, ProjectVersionRef owner, ProjectVersionRef dep, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return new SimpleDependencyRelationship(source, owner, IdentityUtils.artifact(dep, null, null), scope, index, managed, inherited, optional, new ProjectRef[0]);
    }

    public static DependencyRelationship dependency(URI source, ProjectVersionRef owner, String groupId, String artifactId, String version, String type, String classifier, boolean optional, DependencyScope scope, int index, boolean managed, boolean inherited) throws InvalidVersionSpecificationException {
        return new SimpleDependencyRelationship(source, owner, IdentityUtils.artifact(groupId, artifactId, version, type, classifier), scope, index, managed, inherited, optional, new ProjectRef[0]);
    }

    public static DependencyRelationship dependency(URI source, ProjectVersionRef owner, ProjectVersionRef dep, String type, String classifier, boolean optional, DependencyScope scope, int index, boolean managed, boolean inherited) throws InvalidVersionSpecificationException {
        return new SimpleDependencyRelationship(source, owner, IdentityUtils.artifact(dep, type, classifier), scope, index, managed, inherited, optional, new ProjectRef[0]);
    }

    public static DependencyRelationship dependency(URI source, URI pomLocation, ProjectVersionRef owner, String groupId, String artifactId, String version, int index, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return RelationshipUtils.dependency(source, pomLocation, owner, groupId, artifactId, version, null, null, optional, null, index, false, inherited);
    }

    public static DependencyRelationship dependency(URI source, URI pomLocation, ProjectVersionRef owner, ProjectVersionRef dep, int index, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return RelationshipUtils.dependency(source, pomLocation, owner, dep, null, null, optional, null, index, false, inherited);
    }

    public static DependencyRelationship dependency(URI source, URI pomLocation, ProjectVersionRef owner, String groupId, String artifactId, String version, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return RelationshipUtils.dependency(source, pomLocation, owner, groupId, artifactId, version, null, null, optional, scope, index, managed, inherited);
    }

    public static DependencyRelationship dependency(URI source, URI pomLocation, ProjectVersionRef owner, ProjectVersionRef dep, DependencyScope scope, int index, boolean managed, boolean inherited, boolean optional) throws InvalidVersionSpecificationException {
        return new SimpleDependencyRelationship(source, pomLocation, owner, IdentityUtils.artifact(dep, null, null), scope, index, managed, inherited, optional, new ProjectRef[0]);
    }

    public static DependencyRelationship dependency(URI source, URI pomLocation, ProjectVersionRef owner, String groupId, String artifactId, String version, String type, String classifier, boolean optional, DependencyScope scope, int index, boolean managed, boolean inherited) throws InvalidVersionSpecificationException {
        return new SimpleDependencyRelationship(source, pomLocation, owner, IdentityUtils.artifact(groupId, artifactId, version, type, classifier), scope, index, managed, inherited, optional, new ProjectRef[0]);
    }

    public static DependencyRelationship dependency(URI source, URI pomLocation, ProjectVersionRef owner, ProjectVersionRef dep, String type, String classifier, boolean optional, DependencyScope scope, int index, boolean managed, boolean inherited) throws InvalidVersionSpecificationException {
        return new SimpleDependencyRelationship(source, pomLocation, owner, IdentityUtils.artifact(dep, type, classifier), scope, index, managed, inherited, optional, new ProjectRef[0]);
    }

    public static void filterTerminalParents(Collection<? extends ProjectRelationship<?, ?>> rels) {
        Iterator<ProjectRelationship<?, ?>> it = rels.iterator();
        while (it.hasNext()) {
            ProjectRelationship<?, ?> rel = it.next();
            if (!(rel instanceof SimpleParentRelationship) || !((ParentRelationship)rel).isTerminus()) continue;
            it.remove();
        }
    }

    public static URI profileLocation(String profile) {
        if (profile == null || profile.trim().length() < 1) {
            return RelationshipConstants.POM_ROOT_URI;
        }
        try {
            return new URI("pom:profile:" + profile);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot construct pom-profile URI: 'pom:profile:" + profile + "'");
        }
    }
}

