/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.RepositoryInjectionState;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="repository-injection")
@Singleton
public class RepositoryInjectionManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ModelIO modelBuilder;
    private ManipulationSession session;

    @Inject
    public RepositoryInjectionManipulator(ModelIO modelBuilder) {
        this.modelBuilder = modelBuilder;
    }

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new RepositoryInjectionState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        RepositoryInjectionState state = this.session.getState(RepositoryInjectionState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        Model remoteModel = this.modelBuilder.resolveRawModel(state.getRemoteRepositoryInjectionMgmt());
        List<Repository> remoteRepositories = remoteModel.getRepositories();
        List<Repository> remotePluginRepositories = remoteModel.getPluginRepositories();
        for (Project project : projects) {
            String ga = IdUtils.ga(project);
            this.logger.info("Applying changes to: " + ga);
            Model model = project.getModel();
            if (!this.checkProject(state, project)) continue;
            List<Repository> repositories = model.getRepositories();
            if (!remoteRepositories.isEmpty()) {
                Iterator<Repository> i1 = remoteRepositories.iterator();
                while (i1.hasNext()) {
                    this.addRepository(repositories, i1.next());
                }
                changed.add(project);
            }
            List<Repository> pluginRepositories = model.getPluginRepositories();
            if (remotePluginRepositories.isEmpty()) continue;
            Iterator<Repository> i2 = remotePluginRepositories.iterator();
            while (i2.hasNext()) {
                this.addRepository(pluginRepositories, i2.next());
            }
            changed.add(project);
        }
        return changed;
    }

    private void addRepository(List<Repository> repositories, Repository repository) {
        Iterator<Repository> i = repositories.iterator();
        while (i.hasNext()) {
            Repository r = i.next();
            if (!repository.getId().equals(r.getId())) continue;
            this.logger.debug("Removing local repository {} ", (Object)r);
            i.remove();
            break;
        }
        this.logger.debug("Adding repository {}", (Object)repository);
        repositories.add(repository);
    }

    private boolean checkProject(RepositoryInjectionState state, Project project) {
        boolean result = false;
        List<ProjectRef> gaToApply = state.getRemoteRepositoryInjectionTargets();
        if (gaToApply != null) {
            for (ProjectRef p : gaToApply) {
                if (p.getArtifactId().contains("*") && p.getGroupId().equals(project.getGroupId())) {
                    result = true;
                    continue;
                }
                if (!p.equals(project.getKey().asProjectRef())) continue;
                result = true;
            }
            this.logger.debug("Checking project {} against possible GAs {} and found match {}", project.getKey().asProjectRef(), gaToApply, result);
        } else if (project.isInheritanceRoot()) {
            result = true;
        }
        return result;
    }

    @Override
    public int getExecutionIndex() {
        return 65;
    }
}

