/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.auth;

import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.commonjava.maven.galley.auth.PasswordEntry;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.spi.auth.PasswordManager;

@Named
@Alternative
public class AttributePasswordManager
implements PasswordManager {
    private static final String PASSWORD_PREFIX = "password_";

    @Override
    public String getPassword(PasswordEntry id) {
        Location loc = id.getLocation();
        String type = id.getPasswordType();
        return loc.getAttribute(PASSWORD_PREFIX + type, String.class);
    }

    public static void bind(Location loc, String type, String password) {
        if (password == null) {
            return;
        }
        loc.setAttribute(PASSWORD_PREFIX + type, password);
    }

    public static void bind(PasswordEntry pwid, String password) {
        if (password == null) {
            return;
        }
        pwid.getLocation().setAttribute(PASSWORD_PREFIX + pwid.getPasswordType(), password);
    }
}

