/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.commonjava.util.jhttpc.INTERNAL.conn.ConnectionManagerTracker;
import org.commonjava.util.jhttpc.INTERNAL.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackedHttpClient
extends CloseableHttpClient {
    private final CloseableHttpClient delegate;
    private final ConnectionManagerTracker managerWrapper;
    private Set<WeakReference<HttpRequest>> requests = new HashSet<WeakReference<HttpRequest>>();
    private Set<WeakReference<CloseableHttpResponse>> responses = new HashSet<WeakReference<CloseableHttpResponse>>();

    public TrackedHttpClient(CloseableHttpClient delegate, ConnectionManagerTracker managerWrapper) {
        this.delegate = delegate;
        this.managerWrapper = managerWrapper;
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Logger logger2 = LoggerFactory.getLogger(this.getClass());
        logger2.info("Tracking request/response");
        this.requests.add(new WeakReference<HttpRequest>(request));
        CloseableHttpResponse response = this.delegate.execute(target, request, context);
        this.responses.add(new WeakReference<CloseableHttpResponse>(response));
        return response;
    }

    @Override
    public void close() throws IOException {
        HttpUtils.cleanupResources(this.delegate, this.requests, this.responses);
        if (this.managerWrapper != null) {
            this.managerWrapper.release();
        }
        this.delegate.close();
    }

    @Override
    @Deprecated
    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    @Override
    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }
}

