/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.util;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static void cleanupResources(CloseableHttpClient client, HttpUriRequest request, CloseableHttpResponse response) {
        if (response != null && response.getEntity() != null) {
            EntityUtils.consumeQuietly(response.getEntity());
            IOUtils.closeQuietly((Closeable)response);
        }
        if (request != null && request instanceof AbstractExecutionAwareRequest) {
            ((AbstractExecutionAwareRequest)((Object)request)).reset();
        }
        if (client != null) {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    public static void cleanupResources(CloseableHttpClient client, Set<WeakReference<HttpRequest>> requests, Set<WeakReference<CloseableHttpResponse>> responses) {
        if (responses != null) {
            for (WeakReference<HttpMessage> weakReference : responses) {
                CloseableHttpResponse response;
                if (weakReference == null || (response = (CloseableHttpResponse)weakReference.get()) == null || response.getEntity() == null) continue;
                EntityUtils.consumeQuietly(response.getEntity());
                IOUtils.closeQuietly((Closeable)response);
            }
        }
        if (requests != null) {
            for (WeakReference<HttpMessage> weakReference : requests) {
                HttpRequest request;
                if (weakReference == null || (request = (HttpRequest)weakReference.get()) == null || !(request instanceof AbstractExecutionAwareRequest)) continue;
                ((AbstractExecutionAwareRequest)request).reset();
            }
        }
        if (client != null) {
            IOUtils.closeQuietly((Closeable)client);
        }
    }
}

