/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_Win32
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_Win32.class);
    private volatile Boolean supportSymlinks;

    public FS_Win32() {
    }

    protected FS_Win32(FS src) {
        super(src);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32(this);
    }

    @Override
    public boolean supportsExecute() {
        return false;
    }

    @Override
    public boolean canExecute(File f) {
        return false;
    }

    @Override
    public boolean setExecute(File f, boolean canExec) {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return true;
    }

    @Override
    public WorkingTreeIterator.Entry[] list(File directory, final FileTreeIterator.FileModeStrategy fileModeStrategy) {
        final ArrayList result = new ArrayList();
        final FS_Win32 fs = this;
        final boolean checkExecutable = ((FS)fs).supportsExecute();
        try {
            Files.walkFileTree(directory.toPath(), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    File f = file.toFile();
                    FS.Attributes attributes = new FS.Attributes(fs, f, true, attrs.isDirectory(), checkExecutable && f.canExecute(), attrs.isSymbolicLink(), attrs.isRegularFile(), attrs.creationTime().toMillis(), attrs.lastModifiedTime().toInstant(), attrs.size());
                    result.add(new FileTreeIterator.FileEntry(f, fs, attributes, fileModeStrategy));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result.isEmpty()) {
            return NO_ENTRIES;
        }
        return result.toArray(new WorkingTreeIterator.Entry[0]);
    }

    @Override
    protected File discoverGitExe() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_Win32.searchPath(path, "git.exe", "git.cmd");
        if (gitExe == null && FS_Win32.searchPath(path, "bash.exe") != null) {
            String w;
            try {
                w = FS_Win32.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            }
            catch (CommandFailedException e) {
                LOG.warn(e.getMessage());
                return null;
            }
            if (!StringUtils.isEmptyOrNull(w)) {
                gitExe = this.resolve(null, w);
            }
        }
        return gitExe;
    }

    @Override
    protected File userHomeImpl() {
        String homePath;
        String home = SystemReader.getInstance().getenv("HOME");
        if (home != null) {
            return this.resolve(null, home);
        }
        String homeDrive = SystemReader.getInstance().getenv("HOMEDRIVE");
        if (homeDrive != null && (homePath = SystemReader.getInstance().getenv("HOMEPATH")) != null) {
            return new File(homeDrive, homePath);
        }
        String homeShare = SystemReader.getInstance().getenv("HOMESHARE");
        if (homeShare != null) {
            return new File(homeShare);
        }
        return super.userHomeImpl();
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(3 + args.length);
        argv.add("cmd.exe");
        argv.add("/c");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    public boolean supportsSymlinks() {
        if (this.supportSymlinks == null) {
            this.detectSymlinkSupport();
        }
        return Boolean.TRUE.equals(this.supportSymlinks);
    }

    private void detectSymlinkSupport() {
        block12: {
            File tempFile = null;
            try {
                try {
                    tempFile = File.createTempFile("tempsymlinktarget", "");
                    File linkName = new File(tempFile.getParentFile(), "tempsymlink");
                    this.createSymLink(linkName, tempFile.getPath());
                    this.supportSymlinks = Boolean.TRUE;
                    linkName.delete();
                }
                catch (IOException | InternalError | UnsupportedOperationException e) {
                    this.supportSymlinks = Boolean.FALSE;
                    if (tempFile == null) break block12;
                    try {
                        FileUtils.delete(tempFile);
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            finally {
                if (tempFile != null) {
                    try {
                        FileUtils.delete(tempFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtils.getFileAttributesBasic(this, path);
    }
}

