/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.stax2.XMLInputFactory2;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.ext.common.model.Project;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.LocatedDependency;
import org.jboss.set.mavendependencyupdater.MavenUtils;

public class PomDependencyUpdater {
    private static final Logger LOG = Logger.getLogger(PomDependencyUpdater.class);

    public static void upgradeDependencies(File pomFile, List<ComponentUpgrade> componentUpgrades) throws XMLStreamException, IOException, XmlPullParserException {
        StringBuilder content = PomHelper.readXmlFile(pomFile);
        Model model = new MavenXpp3Reader().read(new FileInputStream(pomFile));
        XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
        inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
        ModifiedPomXMLEventReader pom = new ModifiedPomXMLEventReader(content, inputFactory);
        for (ComponentUpgrade componentUpgrade : componentUpgrades) {
            ArtifactRef artifact = componentUpgrade.getArtifact();
            Optional<LocatedDependency> locatedDependencyOpt = PomDependencyUpdater.locateDependency(pomFile, artifact);
            if (!locatedDependencyOpt.isPresent()) {
                LOG.errorf("Dependency element for %s was not found.", (Object)artifact);
                continue;
            }
            LocatedDependency locatedDependency = locatedDependencyOpt.get();
            if (locatedDependency.getVersionProperty() != null) {
                PomHelper.setPropertyVersion(pom, locatedDependency.getProfile(), locatedDependency.getVersionProperty(), componentUpgrade.getNewVersion());
                continue;
            }
            PomHelper.setDependencyVersion(pom, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionString(), componentUpgrade.getNewVersion(), model);
        }
        PomDependencyUpdater.writeFile(pomFile, content);
    }

    public static Optional<LocatedDependency> locateDependency(File pomFile, ArtifactRef artifact) throws IOException, XmlPullParserException {
        Model model = new MavenXpp3Reader().read(new FileInputStream(pomFile));
        BiFunction<LocatedDependency.Type, List, Optional> dependencyLocationFn = (type, dependencies) -> {
            String version;
            Optional<Dependency> dependency = MavenUtils.findDependency(dependencies, artifact.getGroupId(), artifact.getArtifactId());
            if (dependency.isPresent() && !StringUtils.isEmpty(version = dependency.get().getVersion())) {
                if (MavenUtils.isProperty(version)) {
                    String propertyName = MavenUtils.extractPropertyName(version);
                    propertyName = PomDependencyUpdater.followTransitiveProperties(propertyName, model);
                    return Optional.of(new LocatedDependency(artifact, (LocatedDependency.Type)((Object)type), propertyName, pomFile.toURI(), null));
                }
                return Optional.of(new LocatedDependency(artifact, (LocatedDependency.Type)((Object)type), null, pomFile.toURI(), null));
            }
            return Optional.empty();
        };
        Optional locatedDependencyOptional = dependencyLocationFn.apply(LocatedDependency.Type.DEPENDENCY, model.getDependencies());
        if (!locatedDependencyOptional.isPresent()) {
            locatedDependencyOptional = dependencyLocationFn.apply(LocatedDependency.Type.MANAGED_DEPENDENCY, model.getDependencyManagement().getDependencies());
        }
        return locatedDependencyOptional;
    }

    public static Optional<LocatedDependency> locateDependency(Project project, ArtifactRef artifact) {
        BiFunction<LocatedDependency.Type, List, Optional> dependencyLocationFn = (type, dependencies) -> {
            String version;
            Optional<Dependency> dependency = MavenUtils.findDependency(dependencies, artifact.getGroupId(), artifact.getArtifactId());
            if (dependency.isPresent() && !StringUtils.isEmpty(version = dependency.get().getVersion())) {
                if (MavenUtils.isProperty(version)) {
                    String propertyName = MavenUtils.extractPropertyName(version);
                    propertyName = PomDependencyUpdater.followTransitiveProperties(propertyName, project);
                    return Optional.of(new LocatedDependency(artifact, (LocatedDependency.Type)((Object)type), propertyName, project.getPom().toURI(), null));
                }
                return Optional.of(new LocatedDependency(artifact, (LocatedDependency.Type)((Object)type), null, project.getPom().toURI(), null));
            }
            return Optional.empty();
        };
        Optional locatedDependencyOptional = dependencyLocationFn.apply(LocatedDependency.Type.DEPENDENCY, project.getModel().getDependencies());
        if (!locatedDependencyOptional.isPresent()) {
            locatedDependencyOptional = dependencyLocationFn.apply(LocatedDependency.Type.MANAGED_DEPENDENCY, project.getModel().getDependencyManagement().getDependencies());
        }
        return locatedDependencyOptional;
    }

    private static void writeFile(File outFile, StringBuilder content) throws IOException {
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter(outFile);){
            IOUtil.copy(content.toString(), (Writer)writer);
        }
    }

    static String followTransitiveProperties(String propertyName, Model model) {
        return PomDependencyUpdater.followTransitiveProperties(propertyName, model, new LinkedHashSet<String>());
    }

    static String followTransitiveProperties(String propertyName, Project project) {
        return PomDependencyUpdater.followTransitiveProperties(propertyName, project, new LinkedHashSet<String>());
    }

    private static String followTransitiveProperties(String propertyName, Model model, Set<String> discoveredProperties) {
        if (!discoveredProperties.add(propertyName)) {
            LOG.warnf("Can't resolve property - circular property chain detected: %s, %s", (Object)discoveredProperties, (Object)propertyName);
            return discoveredProperties.iterator().next();
        }
        String value = model.getProperties().getProperty(propertyName);
        if (value == null) {
            return propertyName;
        }
        if (MavenUtils.isProperty(value)) {
            String referencedPropertyName = MavenUtils.extractPropertyName(value);
            return PomDependencyUpdater.followTransitiveProperties(referencedPropertyName, model, discoveredProperties);
        }
        return propertyName;
    }

    private static String followTransitiveProperties(String propertyName, Project project, Set<String> discoveredProperties) {
        if (!discoveredProperties.add(PomDependencyUpdater.propertySignature(project, propertyName))) {
            LOG.warnf("Can't resolve property - circular property chain detected: %s, %s", (Object)discoveredProperties, (Object)propertyName);
            return discoveredProperties.iterator().next();
        }
        String value = project.getModel().getProperties().getProperty(propertyName);
        if (value == null) {
            if (project.getProjectParent() != null) {
                return PomDependencyUpdater.followTransitiveProperties(propertyName, project.getProjectParent(), discoveredProperties);
            }
            return propertyName;
        }
        if (MavenUtils.isProperty(value)) {
            String referencedPropertyName = MavenUtils.extractPropertyName(value);
            return PomDependencyUpdater.followTransitiveProperties(referencedPropertyName, project, discoveredProperties);
        }
        return propertyName;
    }

    private static String propertySignature(Project project, String propertyName) {
        return String.format("%s:%s:%s", project.getGroupId(), project.getArtifactId(), propertyName);
    }
}

