/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.aggregation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.set.mavendependencyupdater.ArtifactResult;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.LocatedDependency;
import org.jboss.set.mavendependencyupdater.PomDependencyUpdater;
import org.jboss.set.mavendependencyupdater.core.aggregation.ModifiedProperty;

public class ComponentUpgradeAggregator {
    public static List<ArtifactResult<ComponentUpgrade>> aggregateComponentUpgrades(File rootPom, List<ArtifactResult<ComponentUpgrade>> upgrades) throws IOException, XmlPullParserException {
        HashSet<ModifiedProperty> modifiedProperties = new HashSet<ModifiedProperty>();
        ArrayList<ArtifactResult<ComponentUpgrade>> aggregatedUpgrades = new ArrayList<ArtifactResult<ComponentUpgrade>>();
        for (ArtifactResult<ComponentUpgrade> scopedUpgrade : upgrades) {
            LocatedDependency locatedDependency;
            URI uri;
            boolean added;
            Optional<LocatedDependency> locatedDependencyOpt;
            File pomFile;
            Optional<ComponentUpgrade> componentUpgradeOptional = scopedUpgrade.getAny();
            if (!componentUpgradeOptional.isPresent()) continue;
            ComponentUpgrade upgrade = componentUpgradeOptional.get();
            if (upgrade.getProject() != null) {
                pomFile = upgrade.getProject().getPom();
                locatedDependencyOpt = PomDependencyUpdater.locateDependency(upgrade.getProject(), scopedUpgrade.getArtifactRef());
            } else {
                pomFile = rootPom;
                locatedDependencyOpt = PomDependencyUpdater.locateDependency(pomFile, scopedUpgrade.getArtifactRef());
            }
            if (!locatedDependencyOpt.isPresent() || !(added = modifiedProperties.add(new ModifiedProperty(uri = pomFile != null ? pomFile.toURI() : null, (locatedDependency = locatedDependencyOpt.get()).getProfile(), locatedDependency.getVersionProperty(), upgrade.getNewVersion())))) continue;
            aggregatedUpgrades.add(scopedUpgrade);
        }
        return aggregatedUpgrades;
    }
}

