/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.DependencyUpdatesRenderer;
import org.codehaus.mojo.versions.DependencyUpdatesXmlRenderer;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="dependency-updates-report", requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class DependencyUpdatesReport
extends AbstractVersionsReport {
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    private boolean processDependencyManagementTransitive;
    @Parameter(property="dependencyUpdatesReportFormats", defaultValue="html")
    private String[] formats = new String[]{"html"};

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        Set<Dependency> dependencies = new TreeSet<Dependency>(new DependencyComparator());
        dependencies.addAll(this.getProject().getDependencies());
        TreeSet<Dependency> dependencyManagement = new TreeSet<Dependency>(new DependencyComparator());
        if (this.processDependencyManagementTransitive) {
            if (this.getProject().getDependencyManagement() != null && this.getProject().getDependencyManagement().getDependencies() != null) {
                for (Dependency dep : this.getProject().getDependencyManagement().getDependencies()) {
                    this.getLog().debug("Dpmg: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + ":" + dep.getType() + ":" + dep.getScope());
                }
                dependencyManagement.addAll(this.getProject().getDependencyManagement().getDependencies());
            }
        } else if (this.getProject().getOriginalModel().getDependencyManagement() != null && this.getProject().getOriginalModel().getDependencyManagement().getDependencies() != null) {
            for (Dependency dep : this.getProject().getOriginalModel().getDependencyManagement().getDependencies()) {
                this.getLog().debug("Original Dpmg: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + ":" + dep.getType() + ":" + dep.getScope());
            }
            dependencyManagement.addAll(this.getProject().getOriginalModel().getDependencyManagement().getDependencies());
        }
        if (this.processDependencyManagement) {
            dependencies = DependencyUpdatesReport.removeDependencyManagment(dependencies, dependencyManagement);
        }
        try {
            Map<Dependency, ArtifactVersions> dependencyUpdates = this.getHelper().lookupDependenciesUpdates(dependencies, false);
            Map<Dependency, ArtifactVersions> dependencyManagementUpdates = Collections.emptyMap();
            if (this.processDependencyManagement) {
                dependencyManagementUpdates = this.getHelper().lookupDependenciesUpdates(dependencyManagement, false);
            }
            for (String format : this.formats) {
                if ("html".equals(format)) {
                    DependencyUpdatesRenderer renderer = new DependencyUpdatesRenderer(sink, this.getI18n(), this.getOutputName(), locale, dependencyUpdates, dependencyManagementUpdates);
                    renderer.render();
                    continue;
                }
                if (!"xml".equals(format)) continue;
                File outputDir = new File(this.getProject().getBuild().getDirectory());
                if (!outputDir.exists()) {
                    outputDir.mkdirs();
                }
                String outputFile = outputDir.getAbsolutePath() + File.separator + this.getOutputName() + ".xml";
                DependencyUpdatesXmlRenderer xmlGenerator = new DependencyUpdatesXmlRenderer(dependencyUpdates, dependencyManagementUpdates, outputFile);
                xmlGenerator.render();
            }
        }
        catch (ArtifactMetadataRetrievalException | InvalidVersionSpecificationException e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    private static Set<Dependency> removeDependencyManagment(Set<Dependency> dependencies, Set<Dependency> dependencyManagement) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(new DependencyComparator());
        for (Dependency c : dependencies) {
            boolean matched = false;
            Iterator<Dependency> j = dependencyManagement.iterator();
            while (!matched && j.hasNext()) {
                Dependency t = j.next();
                if (!StringUtils.equals(t.getGroupId(), c.getGroupId()) || !StringUtils.equals(t.getArtifactId(), c.getArtifactId()) || t.getScope() != null && !StringUtils.equals(t.getScope(), c.getScope()) || t.getClassifier() != null && !StringUtils.equals(t.getClassifier(), c.getClassifier()) || c.getVersion() != null && t.getVersion() != null && !StringUtils.equals(t.getVersion(), c.getVersion())) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(c);
        }
        return result;
    }

    public String getOutputName() {
        return "dependency-updates-report";
    }
}

