/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.ArtifactScopeEnum;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleTypeAndClassifier;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.model.SimpleScopedArtifactRef;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.impl.Version;
import org.commonjava.maven.ext.core.impl.VersionCalculator;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.PluginState;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="rest-manipulator")
@Singleton
public class RESTCollector
implements Manipulator {
    private static final Logger logger = LoggerFactory.getLogger(RESTCollector.class);
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.session = session;
        session.setState(new RESTState(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect(List<Project> projects) throws ManipulationException {
        RESTState state = this.session.getState(RESTState.class);
        VersioningState vs = this.session.getState(VersioningState.class);
        DependencyState ds = this.session.getState(DependencyState.class);
        PluginState ps = this.session.getState(PluginState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return;
        }
        ArrayList<ProjectVersionRef> newProjectKeys = new ArrayList<ProjectVersionRef>();
        String override = vs.getOverride();
        for (Project project : projects) {
            if (StringUtils.isEmpty(override)) {
                newProjectKeys.add(new SimpleProjectVersionRef(project.getKey().asProjectRef(), RESTCollector.handlePotentialSnapshotVersion(vs, VersionCalculator.handleAlternate(vs, project.getVersion()))));
                continue;
            }
            if (!project.isExecutionRoot()) continue;
            Project p = projects.get(0);
            newProjectKeys.add(new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId(), override));
        }
        HashSet<ProjectVersionRef> restParamSet = new HashSet<ProjectVersionRef>(newProjectKeys);
        Set<ArtifactRef> localDeps = RESTCollector.establishAllDependencies(this.session, projects, null);
        for (ArtifactRef p : localDeps) {
            restParamSet.add(p.asProjectVersionRef());
        }
        ArrayList<ProjectVersionRef> restParam = new ArrayList<ProjectVersionRef>(restParamSet);
        logger.debug("Passing {} GAVs into the REST client api {} ", (Object)restParam.size(), (Object)restParam);
        logger.info("Calling REST client... (with {} GAVs)", (Object)restParam.size());
        long start = System.nanoTime();
        Map<ProjectVersionRef, String> restResult = null;
        try {
            restResult = state.getVersionTranslator().translateVersions(restParam);
            this.printFinishTime(start, restResult != null);
        }
        catch (Throwable throwable) {
            this.printFinishTime(start, restResult != null);
            throw throwable;
        }
        logger.info("REST Client returned {} ", (Object)restResult);
        vs.setRESTMetadata(this.parseVersions(this.session, projects, state, newProjectKeys, restResult));
        HashMap<ArtifactRef, String> overrides = new HashMap<ArtifactRef, String>();
        for (ArtifactRef a : localDeps) {
            if (restResult == null || !restResult.containsKey(a.asProjectVersionRef())) continue;
            overrides.put(a, restResult.get(a.asProjectVersionRef()));
        }
        logger.debug("Setting REST Overrides {} ", (Object)overrides);
        ds.setRemoteRESTOverrides(overrides);
        ps.setRemoteRESTOverrides(overrides);
    }

    private Map<ProjectRef, Set<String>> parseVersions(ManipulationSession session, List<Project> projects, RESTState state, List<ProjectVersionRef> newProjectKeys, Map<ProjectVersionRef, String> restResult) throws ManipulationException {
        HashMap<ProjectRef, Set<String>> versionStates = new HashMap<ProjectRef, Set<String>>();
        for (ProjectVersionRef p : newProjectKeys) {
            if (!restResult.containsKey(p)) continue;
            Set versions = versionStates.computeIfAbsent(p.asProjectRef(), k -> new HashSet());
            versions.add(restResult.get(p));
        }
        logger.debug("Added the following ProjectRef:Version from REST call into VersionState {}", (Object)versionStates);
        for (Project p : projects) {
            if (!p.isExecutionRoot()) continue;
            logger.debug("Calling REST client for blacklist with {}...", (Object)p.getKey().asProjectRef());
            List<ProjectVersionRef> blacklist = state.getVersionTranslator().findBlacklisted(p.getKey().asProjectRef());
            if (blacklist.size() <= 0) break;
            String suffix = PropertiesUtils.getSuffix(session);
            String bVersion = blacklist.get(0).getVersionString();
            String pVersion = p.getVersion();
            logger.debug("REST Client returned for blacklist {} ", (Object)blacklist);
            if (StringUtils.isEmpty(suffix)) {
                logger.warn("No version suffix found ; unable to verify community blacklisting.");
            } else if (blacklist.size() == 1 && !bVersion.contains(suffix)) {
                if (pVersion.contains(suffix)) {
                    pVersion = pVersion.substring(0, pVersion.indexOf(suffix) - 1);
                }
                if (pVersion.equals(bVersion)) {
                    throw new ManipulationException("community artifact '" + blacklist.get(0) + "' has been blacklisted. Unable to build project version " + p.getVersion(), new String[0]);
                }
            }
            Set versions = versionStates.computeIfAbsent(p.getKey().asProjectRef(), k -> new HashSet());
            for (ProjectVersionRef b : blacklist) {
                versions.add(b.getVersionString());
            }
        }
        return versionStates;
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        this.collect(projects);
        return Collections.emptySet();
    }

    @Override
    public int getExecutionIndex() {
        return 10;
    }

    public static Set<ArtifactRef> establishAllDependencies(ManipulationSession session, List<Project> projects, Set<String> activeProfiles) throws ManipulationException {
        List<Profile> profiles;
        VersioningState vs = session.getState(VersioningState.class);
        HashSet<ArtifactRef> localDeps = new HashSet<ArtifactRef>();
        HashSet<String> activeModules = new HashSet<String>();
        boolean scanAll = false;
        if (activeProfiles != null && !activeProfiles.isEmpty()) {
            for (Project project : projects) {
                if (!project.isInheritanceRoot()) continue;
                activeModules.addAll(project.getModel().getModules());
                profiles = project.getModel().getProfiles();
                if (profiles == null) continue;
                for (Profile p : profiles) {
                    if (!activeProfiles.contains(p.getId())) continue;
                    logger.debug("Adding modules for profile {}", (Object)p.getId());
                    activeModules.addAll(p.getModules());
                }
            }
            logger.debug("Found {} active modules with {} active profiles.", (Object)activeModules, (Object)activeProfiles);
        } else {
            scanAll = true;
        }
        for (Project project : projects) {
            if (!project.isInheritanceRoot() && !scanAll && !activeModules.contains(project.getPom().getParentFile().getName())) continue;
            if (project.getModelParent() != null) {
                SimpleProjectVersionRef parent = new SimpleProjectVersionRef(project.getModelParent().getGroupId(), project.getModelParent().getArtifactId(), RESTCollector.handlePotentialSnapshotVersion(vs, project.getModelParent().getVersion()));
                localDeps.add(new SimpleArtifactRef(parent, new SimpleTypeAndClassifier("pom", null)));
            }
            RESTCollector.recordDependencies(session, project, localDeps, project.getResolvedManagedDependencies(session));
            RESTCollector.recordDependencies(session, project, localDeps, project.getResolvedDependencies(session));
            RESTCollector.recordPlugins(session, localDeps, project.getResolvedManagedPlugins(session));
            RESTCollector.recordPlugins(session, localDeps, project.getResolvedPlugins(session));
            profiles = project.getModel().getProfiles();
            if (profiles == null) continue;
            for (Profile p : profiles) {
                if (!scanAll && !activeProfiles.contains(p.getId())) continue;
                RESTCollector.recordDependencies(session, project, localDeps, project.getResolvedProfileManagedDependencies(session).getOrDefault(p, Collections.emptyMap()));
                RESTCollector.recordDependencies(session, project, localDeps, project.getResolvedProfileDependencies(session).getOrDefault(p, Collections.emptyMap()));
                RESTCollector.recordPlugins(session, localDeps, project.getResolvedProfileManagedPlugins(session).getOrDefault(p, Collections.emptyMap()));
                RESTCollector.recordPlugins(session, localDeps, project.getResolvedProfilePlugins(session).getOrDefault(p, Collections.emptyMap()));
            }
        }
        return localDeps;
    }

    private static void recordPlugins(ManipulationSession session, Set<ArtifactRef> deps, Map<ProjectVersionRef, Plugin> plugins) {
        VersioningState vs = session.getState(VersioningState.class);
        for (ProjectVersionRef pvr : plugins.keySet()) {
            deps.add(new SimpleScopedArtifactRef((ProjectVersionRef)new SimpleProjectVersionRef(pvr.asProjectRef(), RESTCollector.handlePotentialSnapshotVersion(vs, pvr.getVersionString())), new SimpleTypeAndClassifier("maven-plugin", null), ArtifactScopeEnum.compile.name()));
        }
    }

    private static void recordDependencies(ManipulationSession session, Project project, Set<ArtifactRef> deps, Map<ArtifactRef, Dependency> dependencies) throws ManipulationException {
        VersioningState vs = session.getState(VersioningState.class);
        RESTState state = session.getState(RESTState.class);
        for (ArtifactRef pvr : dependencies.keySet()) {
            Dependency d = dependencies.get(pvr);
            SimpleScopedArtifactRef sa = new SimpleScopedArtifactRef((ProjectVersionRef)new SimpleProjectVersionRef(pvr.asProjectRef(), RESTCollector.handlePotentialSnapshotVersion(vs, pvr.getVersionString())), new SimpleTypeAndClassifier(d.getType(), d.getClassifier()), StringUtils.isEmpty(d.getScope()) ? ArtifactScopeEnum.compile.name() : PropertyResolver.resolveInheritedProperties(session, project, d.getScope()));
            boolean validate = true;
            if (sa.getVersionString().contains("$")) {
                validate = false;
            }
            if (state != null && !state.isRestSuffixAlign() && (sa.getVersionString().contains(vs.getRebuildSuffix()) || vs.getSuffixAlternatives().stream().anyMatch(s -> sa.getVersionString().contains((CharSequence)s)))) {
                validate = false;
            }
            if (!validate) continue;
            deps.add(sa);
        }
    }

    private static String handlePotentialSnapshotVersion(VersioningState vs, String version) {
        if (vs != null && !vs.isPreserveSnapshot()) {
            return Version.removeSnapshot(version);
        }
        return version;
    }

    private void printFinishTime(long start, boolean finished) {
        long finish = System.nanoTime();
        long minutes = TimeUnit.NANOSECONDS.toMinutes(finish - start);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(finish - start) - minutes * 60L;
        logger.info("REST client finished {}... (took {} min, {} sec, {} millisec)", finished ? "successfully" : "with failures", minutes, seconds, TimeUnit.NANOSECONDS.toMillis(finish - start) - minutes * 60L * 1000L - seconds * 1000L);
    }
}

