/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.model.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdUtils {
    private static final Logger logger = LoggerFactory.getLogger(IdUtils.class);

    private IdUtils() {
    }

    public static List<ProjectVersionRef> parseGAVs(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        String[] gavs = value.split(",");
        ArrayList<ProjectVersionRef> refs = new ArrayList<ProjectVersionRef>();
        for (String gav : gavs) {
            refs.add(SimpleProjectVersionRef.parse(gav));
        }
        return refs;
    }

    public static List<ProjectRef> parseGAs(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        String[] gavs = value.split(",");
        ArrayList<ProjectRef> refs = new ArrayList<ProjectRef>();
        for (String gav : gavs) {
            try {
                ProjectRef ref = SimpleProjectRef.parse(gav);
                refs.add(ref);
            }
            catch (InvalidRefException e) {
                logger.error("Skipping invalid remote management GAV: " + gav);
                throw e;
            }
        }
        return refs;
    }

    public static String gav(Project project) {
        return String.format("%s:%s:%s", project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static String ga(MavenProject project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(Project project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(Parent project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(String g, String a) {
        return String.format("%s:%s", g, a);
    }

    public static String gav(String g, String a, String v) {
        return String.format("%s:%s:%s", g, a, v);
    }
}

