/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io.rest.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.io.rest.Translator;
import org.commonjava.maven.ext.io.rest.exception.RestException;
import org.commonjava.maven.ext.io.rest.mapper.ErrorMessage;
import org.commonjava.maven.ext.io.rest.mapper.GAVSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGAVMapper
implements com.mashape.unirest.http.ObjectMapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String repositoryGroup;
    private final String versionSuffix;
    private String errorString;
    private Translator.RestProtocol protocol;

    public ReportGAVMapper(Translator.RestProtocol protocol, String repositoryGroup, String incrementalSerialSuffix) {
        this.protocol = protocol;
        this.repositoryGroup = repositoryGroup;
        this.versionSuffix = incrementalSerialSuffix;
    }

    @Override
    public Map<ProjectVersionRef, String> readValue(String s) {
        HashMap<ProjectVersionRef, String> result = new HashMap<ProjectVersionRef, String>();
        if (s.length() == 0) {
            this.errorString = "No content to read.";
            return result;
        }
        if (s.startsWith("<")) {
            String stripped = s.replaceAll("<.*?>", "").replaceAll("\n", " ").trim();
            this.logger.debug("Read HTML string '{}' rather than a JSON stream; stripping message to '{}'", (Object)s, (Object)stripped);
            this.errorString = stripped;
            return result;
        }
        try {
            if (s.startsWith("{\"")) {
                this.errorString = this.objectMapper.readValue(s, ErrorMessage.class).toString();
                this.logger.debug("Read message string {}, processed to {} ", (Object)s, (Object)this.errorString);
                return result;
            }
            List responseBody = this.objectMapper.readValue(s, List.class);
            for (Map gav : responseBody) {
                String groupId = (String)gav.get("groupId");
                String artifactId = (String)gav.get("artifactId");
                String version = (String)gav.get("version");
                String bestMatchVersion = (String)gav.get("bestMatchVersion");
                if (bestMatchVersion == null) continue;
                SimpleProjectVersionRef project = new SimpleProjectVersionRef(groupId, artifactId, version);
                result.put(project, bestMatchVersion);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to decode map when reading string {}", (Object)s);
            throw new RestException("Failed to read list-of-maps response from version server: " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String writeValue(Object value) {
        List projects = (List)value;
        ArrayList<Map<String, Object>> requestBody = new ArrayList<Map<String, Object>>();
        for (ProjectVersionRef project : projects) {
            HashMap<String, String> gav = new HashMap<String, String>();
            gav.put("groupId", project.getGroupId());
            gav.put("artifactId", project.getArtifactId());
            gav.put("version", project.getVersionString());
            requestBody.add(gav);
        }
        if (this.protocol != Translator.RestProtocol.CURRENT) {
            throw new RestException("Unknown protocol value " + (Object)((Object)this.protocol));
        }
        GAVSchema request = new GAVSchema(new String[0], new String[0], this.repositoryGroup, this.versionSuffix, requestBody);
        try {
            return this.objectMapper.writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            throw new RestException("Failed to serialize version request: " + e.getMessage(), e);
        }
    }

    public String getErrorString() {
        return this.errorString;
    }
}

