/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.internal.BouncyCastleGpgKey;
import org.eclipse.jgit.lib.internal.BouncyCastleGpgKeyLocator;
import org.eclipse.jgit.lib.internal.BouncyCastleGpgKeyPassphrasePrompt;
import org.eclipse.jgit.transport.CredentialsProvider;

public class BouncyCastleGpgSigner
extends GpgSigner {
    private static void registerBouncyCastleProviderIfNecessary() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public BouncyCastleGpgSigner() {
        BouncyCastleGpgSigner.registerBouncyCastleProviderIfNecessary();
    }

    @Override
    public boolean canLocateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                boolean bl = gpgKey != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
            return false;
        }
    }

    private BouncyCastleGpgKey locateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt) throws CanceledException, UnsupportedCredentialItem, IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, URISyntaxException {
        if (gpgSigningKey == null || gpgSigningKey.isEmpty()) {
            gpgSigningKey = committer.getEmailAddress();
        }
        BouncyCastleGpgKeyLocator keyHelper = new BouncyCastleGpgKeyLocator(gpgSigningKey, passphrasePrompt);
        return keyHelper.findSecretKey();
    }

    @Override
    public void sign(@NonNull CommitBuilder commit, @Nullable String gpgSigningKey, @NonNull PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                PGPSecretKey secretKey = gpgKey.getSecretKey();
                if (secretKey == null) {
                    throw new JGitInternalException(JGitText.get().unableToSignCommitNoSecretKey);
                }
                char[] passphrase = passphrasePrompt.getPassphrase(secretKey.getPublicKey().getFingerprint(), gpgKey.getOrigin());
                PGPPrivateKey privateKey = secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(passphrase));
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 8).setProvider("BC"));
                signatureGenerator.init(0, privateKey);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                Throwable throwable2 = null;
                Object var15_19 = null;
                try (BCPGOutputStream out = new BCPGOutputStream(new ArmoredOutputStream(buffer));){
                    signatureGenerator.update(commit.build());
                    signatureGenerator.generate().encode(out);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                commit.setGpgSignature(new GpgSignature(buffer.toByteArray()));
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

