/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.processingstrategies;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.set.mavendependencyupdater.ArtifactResult;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.HtmlReportProcessingStrategy;

public class EmailReportProcessingStrategy
extends HtmlReportProcessingStrategy {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final String smtpHost;
    private final String smtpPort;
    private final String fromAddress;
    private final String toAddress;
    private final String subject;

    public EmailReportProcessingStrategy(Configuration configuration, File pomFile, String smtpHost, String smtpPort, String fromAddress, String toAddress, String subject, String outputFile) {
        super(configuration, pomFile, outputFile);
        this.outputStream = new PrintStream(this.baos);
        this.smtpHost = smtpHost;
        this.smtpPort = smtpPort;
        this.fromAddress = fromAddress;
        this.toAddress = toAddress;
        this.subject = subject;
    }

    @Override
    public boolean process(List<ArtifactResult<ComponentUpgrade>> upgrades) throws Exception {
        super.process(upgrades);
        if (upgrades.size() == 0) {
            return true;
        }
        Properties prop = new Properties();
        prop.put("mail.smtp.auth", (Object)false);
        prop.put("mail.smtp.host", this.smtpHost);
        prop.put("mail.smtp.port", this.smtpPort);
        Session session = Session.getInstance(prop);
        MimeMessage message = new MimeMessage(session);
        message.setFrom(new InternetAddress(this.fromAddress));
        message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(this.toAddress));
        message.setSubject(this.subject);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent(this.baos.toString(), "text/html");
        MimeMultipart multipart = new MimeMultipart();
        ((Multipart)multipart).addBodyPart(mimeBodyPart);
        message.setContent(multipart);
        LOG.infof("Sending the report email to %s", (Object)this.toAddress);
        Transport.send(message);
        PrintStream printStream = new PrintStream(this.outputFile);
        printStream.println(this.baos);
        return true;
    }
}

