/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.projectparser;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.io.PomIO;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.common.ident.ScopedArtifactRef;
import org.jboss.set.mavendependencyupdater.common.ident.SimpleScopedArtifactRef;

public class PmeDependencyCollector {
    private static final Logger LOG = Logger.getLogger(PmeDependencyCollector.class);
    private ManipulationSession session;
    private PomIO pomIO;
    private PlexusContainer container;
    private final List<Project> projects;
    private final List<ProjectVersionRef> projectRefs;
    private final Map<Project, Collection<ScopedArtifactRef>> projectsDependencies = new HashMap<Project, Collection<ScopedArtifactRef>>();
    private final Project rootProject;

    public PmeDependencyCollector(File pomFile) throws ManipulationException {
        LOG.debugf("Creating collector for project %s", (Object)pomFile);
        this.createSession(pomFile, null);
        this.projects = this.pomIO.parseProject(pomFile);
        this.projectRefs = this.projects.stream().map(PmeDependencyCollector::toProjectVersionRef).collect(Collectors.toList());
        this.rootProject = this.projects.stream().filter(Project::isInheritanceRoot).findFirst().get();
        this.collectProjectDependencies();
    }

    public Map<Project, Collection<ScopedArtifactRef>> getDependenciesPerProjects() {
        return this.projectsDependencies;
    }

    public Map<ProjectRef, Collection<ScopedArtifactRef>> getDependenciesPerProjectRefs() {
        HashMap<ProjectRef, Collection<ScopedArtifactRef>> result = new HashMap<ProjectRef, Collection<ScopedArtifactRef>>();
        for (Project p : this.projectsDependencies.keySet()) {
            result.put(PmeDependencyCollector.toProjectRef(p), this.projectsDependencies.get(p));
        }
        return result;
    }

    public Collection<ScopedArtifactRef> getRootProjectDependencies() {
        return this.projectsDependencies.get(this.rootProject);
    }

    public Collection<ScopedArtifactRef> getAllProjectDependencies() {
        return this.projectsDependencies.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private void collectProjectDependencies() throws ManipulationException {
        for (Project project : this.projects) {
            HashSet<ScopedArtifactRef> dependencies = new HashSet<ScopedArtifactRef>();
            this.projectsDependencies.put(project, dependencies);
            this.collectDependencies(dependencies, project.getResolvedManagedDependencies(this.session));
            this.collectDependencies(dependencies, project.getResolvedDependencies(this.session));
        }
    }

    private void collectDependencies(Collection<ScopedArtifactRef> collectTo, Map<ArtifactRef, Dependency> dependencies) {
        for (Map.Entry<ArtifactRef, Dependency> entry : dependencies.entrySet()) {
            ArtifactRef ref = entry.getKey();
            Dependency dep = entry.getValue();
            if (this.projectRefs.contains(ref.asProjectVersionRef()) || ref.getVersionString().contains("&")) continue;
            collectTo.add(new SimpleScopedArtifactRef(ref, dep.getScope()));
        }
    }

    private void createSession(File target, File settings) {
        try {
            DefaultContainerConfiguration config = new DefaultContainerConfiguration();
            config.setClassPathScanning("on");
            config.setComponentVisibility("global");
            config.setName("PME-CLI");
            this.container = new DefaultPlexusContainer(config);
            this.pomIO = this.container.lookup(PomIO.class);
            this.session = this.container.lookup(ManipulationSession.class);
            MavenExecutionRequest req = new DefaultMavenExecutionRequest().setSystemProperties(System.getProperties()).setRemoteRepositories(Collections.emptyList());
            MavenArtifactRepository ar = null;
            if (settings == null) {
                settings = new File(System.getProperty("user.home"), ".m2/settings.xml");
                ar = new MavenArtifactRepository();
                ar.setUrl("file://" + System.getProperty("user.home") + "/.m2/repository");
                req.setLocalRepository(ar);
            }
            req.setUserSettingsFile(settings);
            req.setGlobalSettingsFile(settings);
            if (ar != null) {
                ar.setUrl("file://" + req.getLocalRepositoryPath());
            }
            MavenSession mavenSession = new MavenSession(this.container, null, req, new DefaultMavenExecutionResult());
            mavenSession.getRequest().setPom(target);
            this.session.setMavenSession(mavenSession);
        }
        catch (PlexusContainerException | ComponentLookupException e) {
            throw new IllegalStateException("Caught problem instantiating PlexusContainer", e);
        }
    }

    private static ProjectRef toProjectRef(Project project) {
        return new SimpleProjectRef(project.getGroupId(), project.getArtifactId());
    }

    private static ProjectVersionRef toProjectVersionRef(Project project) {
        return new SimpleProjectVersionRef(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }
}

