/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHRepositorySearchBuilder
extends GHSearchBuilder<GHRepository> {
    GHRepositorySearchBuilder(GitHub root) {
        super(root, RepositorySearchResult.class);
    }

    public GHRepositorySearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHRepositorySearchBuilder in(String v) {
        return this.q("in:" + v);
    }

    public GHRepositorySearchBuilder size(String v) {
        return this.q("size:" + v);
    }

    public GHRepositorySearchBuilder forks(String v) {
        return this.q("forks:" + v);
    }

    public GHRepositorySearchBuilder created(String v) {
        return this.q("created:" + v);
    }

    public GHRepositorySearchBuilder pushed(String v) {
        return this.q("pushed:" + v);
    }

    public GHRepositorySearchBuilder user(String v) {
        return this.q("user:" + v);
    }

    public GHRepositorySearchBuilder repo(String v) {
        return this.q("repo:" + v);
    }

    public GHRepositorySearchBuilder language(String v) {
        return this.q("language:" + v);
    }

    public GHRepositorySearchBuilder stars(String v) {
        return this.q("stars:" + v);
    }

    public GHRepositorySearchBuilder topic(String v) {
        return this.q("topic:" + v);
    }

    public GHRepositorySearchBuilder order(GHDirection v) {
        this.req.with("order", v);
        return this;
    }

    public GHRepositorySearchBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    @Override
    protected String getApiUrl() {
        return "/search/repositories";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepositorySearchResult
    extends SearchResult<GHRepository> {
        private GHRepository[] items;

        private RepositorySearchResult() {
        }

        GHRepository[] getItems(GitHub root) {
            for (GHRepository item : this.items) {
                item.wrap(root);
            }
            return this.items;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        STARS,
        FORKS,
        UPDATED;

    }
}

