/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;

public class TokenizedVersion
implements Comparable<TokenizedVersion> {
    private static final String DELIMITERS = ".-_";
    private static final Pattern NUMERICAL_SEGMENT_PATTERN = Pattern.compile("^\\d+");
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("^((\\d+)([._-]\\d+)*)([._-](.*))?");
    private static final List<String> BUILD_SUFFIXES = new ArrayList<String>();
    private static final VersionScheme AETHER_VERSION_SCHEME;
    private List<String> segments;
    private List<String> delimiters;
    private String versionString;

    private TokenizedVersion(String versionString, List<String> segments, List<String> delimiters) {
        this.versionString = versionString;
        this.segments = segments;
        this.delimiters = delimiters;
    }

    public static TokenizedVersion parse(String version) {
        StringTokenizer tokenizer = new StringTokenizer(version, DELIMITERS, true);
        ArrayList<String> segments = new ArrayList<String>();
        ArrayList<String> delimiters = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            delimiters.add(tokenizer.nextToken());
        }
        return new TokenizedVersion(version, segments, delimiters);
    }

    public boolean isPrefixOf(TokenizedVersion version) {
        Iterator<String> thisIterator = this.segments.iterator();
        Iterator<String> thatIterator = version.segments.iterator();
        while (thisIterator.hasNext()) {
            if (!thatIterator.hasNext()) {
                return false;
            }
            if (thisIterator.next().equals(thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    public String getQualifier() {
        Matcher matcher = QUALIFIER_PATTERN.matcher(this.versionString);
        if (matcher.matches()) {
            String q = matcher.group(5);
            return q == null ? "" : q;
        }
        return this.versionString;
    }

    public String getNumericalPart() {
        Matcher matcher = QUALIFIER_PATTERN.matcher(this.versionString);
        if (matcher.matches()) {
            String q = matcher.group(1);
            return q == null ? "" : q;
        }
        return "";
    }

    public String[] getNumericalSegments() {
        ArrayList<String> numericalSegments = new ArrayList<String>();
        for (int i = 0; i < this.segments.size() && NUMERICAL_SEGMENT_PATTERN.matcher(this.segments.get(i)).matches(); ++i) {
            numericalSegments.add(this.segments.get(i));
        }
        return numericalSegments.toArray(new String[0]);
    }

    public String getPrefix(int numOfSegments) {
        if (this.segments.size() == 0 || numOfSegments == 0) {
            return "";
        }
        StringBuilder prefix = new StringBuilder(this.segments.get(0));
        for (int i = 1; i < Integer.min(numOfSegments, this.segments.size()); ++i) {
            prefix.append(this.delimiters.get(i - 1)).append(this.segments.get(i));
        }
        return prefix.toString();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public Version toAetherVersion() {
        try {
            return AETHER_VERSION_SCHEME.parseVersion(this.versionString);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Can't parse version: " + e.getVersion(), e);
        }
    }

    public boolean hasBuildSuffix() {
        int size = this.segments.size();
        return size > 3 && BUILD_SUFFIXES.contains(this.segments.get(size - 2).toLowerCase());
    }

    public String[] getBuildSuffixSegments() {
        if (this.hasBuildSuffix()) {
            return new String[]{this.segments.get(this.segments.size() - 2).toLowerCase(), this.segments.get(this.segments.size() - 1).toLowerCase()};
        }
        return new String[0];
    }

    public String getVersionWithoutBuildSuffix() {
        if (this.hasBuildSuffix()) {
            return this.getPrefix(this.segments.size() - 2);
        }
        return this.versionString;
    }

    @Override
    public int compareTo(TokenizedVersion that) {
        try {
            Version v1 = AETHER_VERSION_SCHEME.parseVersion(this.getVersionWithoutBuildSuffix());
            Version v2 = AETHER_VERSION_SCHEME.parseVersion(that.getVersionWithoutBuildSuffix());
            int comp = v1.compareTo((Object)v2);
            if (comp != 0) {
                return comp;
            }
            String[] suffix1 = this.getBuildSuffixSegments();
            String[] suffix2 = that.getBuildSuffixSegments();
            if (suffix1.length == 0 && suffix2.length == 0) {
                return 0;
            }
            if (suffix1.length < suffix2.length) {
                return -1;
            }
            if (suffix1.length > suffix2.length) {
                return 1;
            }
            comp = suffix1[0].compareTo(suffix2[0]);
            if (comp != 0) {
                return comp;
            }
            try {
                Integer num1 = Integer.parseInt(suffix1[1]);
                Integer num2 = Integer.parseInt(suffix2[1]);
                return num1.compareTo(num2);
            }
            catch (NumberFormatException e) {
                return suffix1[1].compareTo(suffix2[1]);
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Can't parse version: " + e.getVersion(), e);
        }
    }

    public String toString() {
        return this.versionString;
    }

    static {
        BUILD_SUFFIXES.add("redhat");
        BUILD_SUFFIXES.add("jbossorg");
        AETHER_VERSION_SCHEME = new GenericVersionScheme();
    }
}

