/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater;

import java.util.Optional;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;

public class ArtifactResult<T> {
    private final ArtifactRef artifactRef;
    private final Optional<T> latestConfigured;
    private final Optional<T> latestMinor;
    private final Optional<T> veryLatest;

    public static <U> ArtifactResult<U> empty(ArtifactRef artifactRef) {
        return new ArtifactResult(artifactRef, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static <U> ArtifactResult<U> of(ArtifactRef artifactRef, U single) {
        return new ArtifactResult(artifactRef, Optional.of(single), Optional.empty(), Optional.empty());
    }

    public static ArtifactResult<ComponentUpgrade> of(ComponentUpgrade single) {
        return new ArtifactResult(single.getArtifact(), Optional.of(single), Optional.empty(), Optional.empty());
    }

    ArtifactResult(ArtifactRef artifactRef, Optional<T> latestConfigured, Optional<T> latestMinor, Optional<T> veryLatest) {
        this.artifactRef = artifactRef;
        this.latestConfigured = latestConfigured;
        this.latestMinor = latestMinor;
        this.veryLatest = veryLatest;
    }

    ArtifactResult(ArtifactRef artifactRef, T latestConfigured, T latestMinor, T veryLatest) {
        this.artifactRef = artifactRef;
        this.latestConfigured = Optional.ofNullable(latestConfigured);
        this.latestMinor = Optional.ofNullable(latestMinor);
        this.veryLatest = Optional.ofNullable(veryLatest);
    }

    public ArtifactRef getArtifactRef() {
        return this.artifactRef;
    }

    public Optional<T> getLatestConfigured() {
        return this.latestConfigured;
    }

    public Optional<T> getLatestMinor() {
        return this.latestMinor;
    }

    public Optional<T> getVeryLatest() {
        return this.veryLatest;
    }

    public Optional<T> getAny() {
        return Optional.ofNullable(this.latestConfigured.orElse(this.latestMinor.orElse(this.veryLatest.orElse(null))));
    }

    public boolean anyPresent() {
        return this.latestConfigured.isPresent() || this.latestMinor.isPresent() || this.veryLatest.isPresent();
    }
}

