/*
 * Copyright 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.set.aphrodite.domain.spi;

import java.util.stream.Stream;

import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;

/**
 * @author wangc
 *
 */
public interface PatchHome {
    /*
     * Retrieve Patches with the given <code>Issue</code>.
     *
     * @param issue the input <code>Issue</code> object
     *
     * @return a stream of retrieved <code>Patch</code>
     */
    Stream<Patch> findPatchesByIssue(Issue issue);

}
