/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.net.URL;
import java.util.Date;
import java.util.regex.Pattern;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.MergeableState;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.Repository;

public class PullRequest {
    private static final Pattern UPGRADE_TITLE = Pattern.compile("\\s*Upgrade \\s*", 2);
    private final String id;
    private final URL url;
    private final Codebase codebase;
    private PullRequestState state;
    private String title;
    private String body;
    private Repository repository;
    private boolean mergeable;
    private boolean merged;
    private boolean upgrade;
    private MergeableState mergableState;
    private Date mergedAt;

    public PullRequest(String id, URL url, Repository repository, Codebase codebase, PullRequestState state, String title, String body, boolean mergeable, boolean merged, MergeableState mergeableState, Date mergedAt) {
        this.id = id;
        this.url = url;
        this.codebase = codebase;
        this.state = state;
        this.title = title;
        this.body = body;
        this.repository = repository;
        this.mergeable = mergeable;
        this.merged = merged;
        this.mergedAt = mergedAt;
        if (this.title != null) {
            this.upgrade = UPGRADE_TITLE.matcher(this.title).find();
        }
    }

    public String getId() {
        return this.id;
    }

    public URL getURL() {
        return this.url;
    }

    public Codebase getCodebase() {
        return this.codebase;
    }

    public PullRequestState getState() {
        return this.state;
    }

    public void setState(PullRequestState state) {
        this.state = state;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullRequest pullRequset = (PullRequest)o;
        return this.url.equals(pullRequset.url);
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public MergeableState getMergableState() {
        return this.mergableState;
    }

    public Date getMergedAt() {
        return this.mergedAt;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public String toString() {
        return "PullRequest{url=" + this.url + ", state=" + (Object)((Object)this.state) + ", title='" + this.title + '\'' + ", body='" + this.body + '\'' + ", codebase=" + this.codebase + '}';
    }
}

