/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.container.Container;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Compare;
import org.jboss.set.aphrodite.domain.VersionUpgrade;
import org.jboss.set.aphrodite.domain.spi.CompareHome;

public class Repository {
    private static final Pattern COMPONENT_VERSION = Pattern.compile("[+\\-]\\s+<version\\.(.*)>(.*)</version\\.(.*)>");
    private final URL url;
    private final List<Codebase> codebases = new ArrayList<Codebase>();

    public Repository(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public List<Codebase> getCodebases() {
        return this.codebases;
    }

    public Compare getCompare(String tag1, String tag2) throws NameNotFoundException {
        return ((CompareHome)Container.instance().lookup(CompareHome.class.getSimpleName(), CompareHome.class)).getCompare(this.url, tag1, tag2);
    }

    public List<String> getTags() throws NameNotFoundException {
        return ((CompareHome)Container.instance().lookup(CompareHome.class.getSimpleName(), CompareHome.class)).getTags(this.url);
    }

    public List<String> getBranches() throws NameNotFoundException {
        return ((CompareHome)Container.instance().lookup(CompareHome.class.getSimpleName(), CompareHome.class)).getBranches(this.url);
    }

    public List<VersionUpgrade> getUpgradesForFile(String fileName, String tag1, String tag2) {
        try {
            String diff = this.getCompare(tag1, tag2).getDiffForFile(fileName);
            ArrayList<VersionUpgrade> upgrades = new ArrayList<VersionUpgrade>();
            String[] lines = diff.split(System.lineSeparator());
            String component = null;
            String version = null;
            HashMap<String, String> oldVersions = new HashMap<String, String>();
            for (String line : lines) {
                Matcher m = COMPONENT_VERSION.matcher(line);
                if (!m.find()) continue;
                component = m.group(1);
                version = m.group(2);
                if (!oldVersions.containsKey(component)) {
                    oldVersions.put(component, version);
                    continue;
                }
                upgrades.add(new VersionUpgrade(component, (String)oldVersions.get(component), version));
            }
            return upgrades;
        }
        catch (NameNotFoundException nnfe) {
            return Collections.EMPTY_LIST;
        }
    }

    public List<VersionUpgrade> getComponentUpgrades(String tag1, String tag2) {
        return this.getUpgradesForFile("pom.xml", tag1, tag2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Repository) {
            Repository that = (Repository)obj;
            return this.url.toString().equals(that.url.toString());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public String toString() {
        return "Repository{url=" + this.url + "}";
    }
}

