/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain.internal;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URLUtils {
    public static final String URL_REGEX_STRING = "(http|ftp|https)://(\\w+(:\\w+)@)?([a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]+(/[\\w.@?^=%&:/~+#-]*)?";
    private static final Pattern URL_REGEX = Pattern.compile("(http|ftp|https)://(\\w+(:\\w+)@)?([a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]+(/[\\w.@?^=%&:/~+#-]*)?");

    private URLUtils() {
    }

    public static String[] extractURLs(String source, Pattern initialMatchPattern, boolean multiple) {
        Matcher m = initialMatchPattern.matcher(source);
        if (m.find()) {
            String urlSource = source.substring(m.start(), m.end());
            m = URL_REGEX.matcher(urlSource);
            if (multiple) {
                ArrayList<String> urls = new ArrayList<String>();
                while (m.find()) {
                    urls.add(urlSource.substring(m.start(), m.end()));
                }
                return urls.toArray(new String[urls.size()]);
            }
            if (m.find()) {
                return new String[]{urlSource.substring(m.start(), m.end())};
            }
            return null;
        }
        return null;
    }
}

