/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.repository.services.common.AbstractRepositoryService;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.extras.OkHttpConnector;

public abstract class AbstractGithubService
extends AbstractRepositoryService {
    private static final Log LOG = LogFactory.getLog(AbstractGithubService.class);
    private static final String CACHE_DIR = "cacheDir";
    private static final String CACHE_NAME = "cacheName";
    private static final String CACHE_SIZE = "cacheSize";
    private static final int DEFAULT_CACHE_SIZE = 20;
    private static String cacheDir;
    private static String cacheName;
    private static String cacheSize;
    private static File cacheFile;
    private static Cache cache;
    protected static GitHub github;
    protected static GHUser user;

    public AbstractGithubService(RepositoryType REPOSITORY_TYPE) {
        super(REPOSITORY_TYPE);
    }

    public boolean init(RepositoryConfig config) {
        boolean parentInitiated = super.init(config);
        if (!parentInitiated) {
            return false;
        }
        try {
            if (github != null && github.isCredentialValid()) {
                return true;
            }
            return AbstractGithubService.commonGithubInit(config);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (String)("Authentication failed for username: " + config.getUsername()), (Exception)e);
            return false;
        }
    }

    public static boolean commonGithubInit(RepositoryConfig config) {
        cacheDir = AbstractGithubService.getValueFromPropertyAndEnv(CACHE_DIR);
        cacheName = AbstractGithubService.getValueFromPropertyAndEnv(CACHE_NAME);
        try {
            if (cacheDir == null || cacheName == null) {
                github = GitHub.connect((String)config.getUsername(), (String)config.getPassword());
            } else {
                cacheFile = new File(cacheDir, cacheName);
                cacheSize = AbstractGithubService.getValueFromPropertyAndEnv(CACHE_SIZE);
                if (cacheSize == null) {
                    cache = new Cache(cacheFile, 0x1400000L);
                } else {
                    int size = 20;
                    try {
                        size = Integer.valueOf(cacheSize);
                    }
                    catch (NumberFormatException e) {
                        Utils.logWarnMessage((Log)LOG, (String)(cacheSize + " is not a valid cache size. Use default size 20MB."));
                    }
                    cache = new Cache(cacheFile, (long)(size * 1024 * 1024));
                }
                github = new GitHubBuilder().withOAuthToken(config.getPassword(), config.getUsername()).withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(new OkHttpClient().setCache(cache)))).build();
            }
            user = github.getUser(config.getUsername());
            return github.isCredentialValid();
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (String)("Authentication failed for username: " + config.getUsername()), (Exception)e);
            return false;
        }
    }

    private static String getValueFromPropertyAndEnv(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return System.getenv(key);
        }
        return value;
    }
}

