/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.RateLimit;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.repository.services.common.RepositoryUtils;
import org.jboss.set.aphrodite.repository.services.github.AbstractGithubService;
import org.jboss.set.aphrodite.repository.services.github.GitHubWrapper;
import org.jboss.set.aphrodite.repository.services.github.GithubUtils;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.RepositoryService;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;

public class GitHubRepositoryService
extends AbstractGithubService
implements RepositoryService {
    private static final Log LOG = LogFactory.getLog(RepositoryService.class);
    private static final GitHubWrapper WRAPPER = new GitHubWrapper();

    public GitHubRepositoryService() {
        super(RepositoryType.GITHUB);
    }

    protected Log getLog() {
        return LOG;
    }

    public PullRequest getPullRequest(URL url) throws NotFoundException {
        this.checkHost(url);
        String[] elements = url.getPath().split("/");
        try {
            int pullId = Integer.parseInt(elements[elements.length - 1]);
            String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
            GHRepository repository = github.getRepository(repositoryId);
            GHPullRequest pullRequest = repository.getPullRequest(pullId);
            return WRAPPER.pullRequestToPullRequest(pullRequest);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (String)url.toString(), (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
        catch (NumberFormatException ex) {
            Utils.logWarnMessage((Log)LOG, (String)("Unable to get pull request from " + url));
            throw new NotFoundException((Throwable)ex);
        }
    }

    public Repository getRepository(URL url) throws NotFoundException {
        this.checkHost(url);
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = github.getRepository(repositoryId);
            Collection<GHBranch> branches = repository.getBranches().values();
            return WRAPPER.toAphroditeRepository(url, branches);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    @Deprecated
    public List<PullRequest> getPullRequestsAssociatedWith(Issue issue) throws NotFoundException {
        Utils.logException((Log)LOG, (Exception)new UnsupportedOperationException("Not yet implemented."));
        return Collections.emptyList();
    }

    public List<PullRequest> getPullRequestsByState(Repository repository, PullRequestState state) throws NotFoundException {
        URL url = repository.getURL();
        this.checkHost(url);
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHIssueState issueState;
            GHRepository githubRepository = github.getRepository(repositoryId);
            try {
                issueState = GHIssueState.valueOf((String)state.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                issueState = GHIssueState.OPEN;
            }
            List pullRequests = githubRepository.getPullRequests(issueState);
            return WRAPPER.toAphroditePullRequests(pullRequests);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    @Deprecated
    public void addCommentToPullRequest(PullRequest pullRequest, String comment) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int id = Integer.parseInt(pullRequest.getId());
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(id);
            issue.comment(comment);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public boolean hasModifiableLabels(Repository repository) throws NotFoundException {
        URL url = repository.getURL();
        this.checkHost(url);
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHMyself myself = github.getMyself();
            GHRepository githubRepository = github.getRepository(repositoryId);
            Set collaborators = githubRepository.listCollaborators().asSet();
            return collaborators.stream().anyMatch(e -> e.getLogin().equals(myself.getLogin()));
        }
        catch (Throwable t) {
            if (t.getMessage().contains("Must have push access")) {
                return false;
            }
            Exception e2 = (Exception)t;
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
    }

    @Deprecated
    public void addLabelToPullRequest(PullRequest pullRequest, String labelName) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = github.getRepository(repositoryId);
            GHLabel newLabel = this.getLabel(repository, labelName);
            GHIssue issue = repository.getIssue(pullRequestId);
            Collection labels = issue.getLabels();
            if (labels.contains(newLabel)) {
                return;
            }
            List<String> list = labels.stream().map(e -> e.getName()).collect(Collectors.toList());
            list.add(newLabel.getName());
            String[] labelArray = list.toArray(new String[list.size()]);
            issue.setLabels(labelArray);
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
    }

    private GHLabel getLabel(GHRepository repository, String labelName) throws NotFoundException, IOException {
        List labels = repository.listLabels().asList();
        return this.getLabel(repository, labelName, labels);
    }

    private GHLabel getLabel(GHRepository repository, String labelName, List<GHLabel> validLabels) throws NotFoundException {
        for (GHLabel label : validLabels) {
            if (!label.getName().equalsIgnoreCase(labelName)) continue;
            return label;
        }
        throw new NotFoundException("No label exists with the name '" + labelName + "' at repository '" + repository.getName() + "'");
    }

    public List<Label> getLabelsFromRepository(Repository repository) throws NotFoundException {
        List labels;
        URL url = repository.getURL();
        this.checkHost(url);
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository githubRepository = github.getRepository(repositoryId);
            labels = githubRepository.listLabels().asList();
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
        return WRAPPER.pullRequestLabeltoPullRequestLabel(labels);
    }

    @Deprecated
    public List<Label> getLabelsFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(Integer.parseInt(pullRequest.getId()));
            return WRAPPER.pullRequestLabeltoPullRequestLabel(issue.getLabels());
        }
        catch (IOException | NumberFormatException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    @Deprecated
    public void setLabelsToPullRequest(PullRequest pullRequest, List<Label> labels) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(pullRequestId);
            ArrayList<GHLabel> issueLabels = new ArrayList<GHLabel>();
            List existingLabels = repository.listLabels().asList();
            for (Label label : labels) {
                issueLabels.add(this.getLabel(repository, label.getName(), existingLabels));
            }
            List<String> list = issueLabels.stream().map(e -> e.getName()).collect(Collectors.toList());
            String[] labelArray = list.toArray(new String[list.size()]);
            issue.setLabels(labelArray);
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
    }

    @Deprecated
    public void removeLabelFromPullRequest(PullRequest pullRequest, String name) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(pullRequestId);
            Collection labels = issue.getLabels();
            for (GHLabel label : labels) {
                if (!label.getName().equalsIgnoreCase(name)) continue;
                List<String> list = labels.stream().map(e -> e.getName()).collect(Collectors.toList());
                list.remove(label.getName());
                String[] labelArray = list.toArray(new String[list.size()]);
                issue.setLabels(labelArray);
                return;
            }
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
        throw new NotFoundException("No label exists with the name '" + name + "' at repository '" + repositoryId + "'");
    }

    @Deprecated
    public List<PullRequest> findPullRequestsRelatedTo(PullRequest pullRequest) {
        try {
            List urls = RepositoryUtils.getPRFromDescription((URL)pullRequest.getURL(), (String)pullRequest.getBody());
            ArrayList<PullRequest> related = new ArrayList<PullRequest>();
            for (URL url : urls) {
                try {
                    if (this.urlExists(url)) {
                        related.add(this.getPullRequest(url));
                        continue;
                    }
                    Utils.logWarnMessage((Log)LOG, (String)("Unable to process url '" + url + "' as it is not located on this service"));
                }
                catch (NotFoundException e) {
                    Utils.logException((Log)LOG, (String)("Unable to retrieve url '" + url + "' referenced in the pull request at: " + pullRequest.getURL()), (Exception)((Object)e));
                }
            }
            return related;
        }
        catch (MalformedURLException | URISyntaxException e) {
            Utils.logException((Log)LOG, (String)("something went wrong while trying to get related pull requests to " + pullRequest.getURL()), (Exception)e);
            return Collections.emptyList();
        }
    }

    @Deprecated
    public CommitStatus getCommitStatusFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        CommitStatus status = null;
        int pullRequestId = Integer.parseInt(pullRequest.getId());
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHCommitState sta;
            List statuses;
            String sha = null;
            GHRepository repository = github.getRepository(repositoryId);
            GHPullRequest ghPullRequest = repository.getPullRequest(pullRequestId);
            List commits = ghPullRequest.listCommits().asList();
            if (commits.size() > 0) {
                sha = ((GHPullRequestCommitDetail)commits.get(commits.size() - 1)).getSha();
            }
            if ((statuses = repository.listCommitStatuses(sha).asList()).size() > 0 && (sta = GithubUtils.getCombineStatus(statuses)) != null) {
                status = CommitStatus.fromString((String)sta.toString());
            }
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
        if (status != null) {
            return status;
        }
        return CommitStatus.UNKNOWN;
    }

    public boolean repositoryAccessable(URL url) {
        if (url.toString().contains("svn.jboss.org")) {
            Utils.logWarnMessage((Log)LOG, (String)("svn repository : " + url + " is not supported."));
            return false;
        }
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = github.getRepository(repositoryId);
            repository.getBranches();
        }
        catch (IOException e) {
            Utils.logWarnMessage((Log)LOG, (String)("repository : " + url + " is not accessable due to " + e.getMessage() + ". Check repository link and your account permission."));
            return false;
        }
        return true;
    }

    public RateLimit getRateLimit() throws NotFoundException {
        try {
            GHRateLimit ghRateLimit = github.getRateLimit();
            return WRAPPER.ghRateLimittoRateLimit(ghRateLimit);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public RepositoryType getRepositoryType() {
        return this.REPOSITORY_TYPE;
    }
}

