/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.spi.PullRequestHome;
import org.jboss.set.aphrodite.repository.services.common.AbstractRepositoryService;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.repository.services.common.RepositoryUtils;
import org.jboss.set.aphrodite.repository.services.github.GitHubWrapper;
import org.jboss.set.aphrodite.repository.services.github.GithubUtils;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.extras.OkHttpConnector;

public class GithubPullRequestHomeService
extends AbstractRepositoryService
implements PullRequestHome {
    private static final Log LOG = LogFactory.getLog(GithubPullRequestHomeService.class);
    private static final GitHubWrapper WRAPPER = new GitHubWrapper();
    private static final int DEFAULT_CACHE_SIZE = 20;
    private String cacheDir;
    private String cacheName;
    private String cacheSize;
    private File cacheFile;
    private Cache cache;
    private GitHub github;

    public GithubPullRequestHomeService(Aphrodite aphrodite) {
        super(RepositoryType.GITHUB);
        AphroditeConfig configuration = aphrodite.getConfig();
        this.init(configuration);
    }

    public boolean init(RepositoryConfig config) {
        boolean parentInitiated = super.init(config);
        if (!parentInitiated) {
            return false;
        }
        this.cacheDir = System.getProperty("cacheDir");
        this.cacheName = System.getProperty("cacheName");
        try {
            if (this.cacheDir == null || this.cacheName == null) {
                this.github = GitHub.connect((String)config.getUsername(), (String)config.getPassword());
            } else {
                this.cacheFile = new File(this.cacheDir, this.cacheName);
                this.cacheSize = System.getProperty("cacheSize");
                if (this.cacheSize == null) {
                    this.cache = new Cache(this.cacheFile, 0x1400000L);
                } else {
                    int size = 20;
                    try {
                        size = Integer.valueOf(this.cacheSize);
                    }
                    catch (NumberFormatException e) {
                        Utils.logWarnMessage((Log)LOG, (String)(this.cacheSize + " is not a valid cache size. Use default size 20MB."));
                    }
                    this.cache = new Cache(this.cacheFile, (long)(size * 1024 * 1024));
                }
                this.github = new GitHubBuilder().withOAuthToken(config.getPassword(), config.getUsername()).withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(new OkHttpClient().setCache(this.cache)))).build();
            }
            return this.github.isCredentialValid();
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (String)("Authentication failed for RepositoryService: " + ((Object)((Object)this)).getClass().getName()), (Exception)e);
            return false;
        }
    }

    public List<PullRequest> findReferencedPullRequests(PullRequest pullRequest) {
        try {
            List urls = RepositoryUtils.getPRFromDescription((URL)pullRequest.getURL(), (String)pullRequest.getBody());
            ArrayList<PullRequest> referencedPullRequests = new ArrayList<PullRequest>();
            for (URL url : urls) {
                if (url.getHost().equals(this.baseUrl.getHost())) {
                    PullRequest validPullRequest = this.getPullRequest(url);
                    if (validPullRequest == null) continue;
                    referencedPullRequests.add(this.getPullRequest(url));
                    continue;
                }
                Utils.logWarnMessage((Log)LOG, (String)("Unable to process url '" + url + "' as it is not located on this service"));
            }
            return referencedPullRequests;
        }
        catch (MalformedURLException | URISyntaxException e) {
            Utils.logException((Log)LOG, (String)("error to get referenced pull requests to " + pullRequest.getURL()), (Exception)e);
            return Collections.emptyList();
        }
    }

    private PullRequest getPullRequest(URL url) {
        String[] elements = url.getPath().split("/");
        int pullId = Integer.parseInt(elements[elements.length - 1]);
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHPullRequest pullRequest = repository.getPullRequest(pullId);
            return WRAPPER.pullRequestToPullRequest(pullRequest);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (String)("Unable to retrieve pull request from url " + url), (Exception)e);
            return null;
        }
    }

    public boolean addComment(PullRequest pullRequest, String comment) {
        URL url = pullRequest.getURL();
        int id = Integer.parseInt(pullRequest.getId());
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(id);
            issue.comment(comment);
            return true;
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            return false;
        }
    }

    public List<Label> getLabels(PullRequest pullRequest) {
        URL url = pullRequest.getURL();
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(Integer.parseInt(pullRequest.getId()));
            return WRAPPER.pullRequestLabeltoPullRequestLabel(issue.getLabels());
        }
        catch (IOException | NumberFormatException e) {
            Utils.logException((Log)LOG, (Exception)e);
            return Collections.emptyList();
        }
    }

    public boolean setLabels(PullRequest pullRequest, List<Label> labels) {
        URL url = pullRequest.getURL();
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(pullRequestId);
            ArrayList<GHLabel> issueLabels = new ArrayList<GHLabel>();
            List existingLabels = repository.listLabels().asList();
            for (Label label : labels) {
                GHLabel validLabel = this.validAndGetLabel(repository, label, existingLabels);
                if (validLabel == null) continue;
                issueLabels.add(validLabel);
            }
            List<String> list = issueLabels.stream().map(e -> e.getName()).collect(Collectors.toList());
            String[] labelArray = list.toArray(new String[list.size()]);
            issue.setLabels(labelArray);
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            return false;
        }
        return true;
    }

    public boolean addLabel(PullRequest pullRequest, Label label) {
        URL url = pullRequest.getURL();
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            List existingLabels = repository.listLabels().asList();
            GHLabel newLabel = this.validAndGetLabel(repository, label, existingLabels);
            if (newLabel == null) {
                Utils.logWarnMessage((Log)LOG, (String)("No label exists with name '" + label.getName() + "' at repository '" + repository.getName() + "'"));
                return false;
            }
            GHIssue issue = repository.getIssue(pullRequestId);
            Collection labels = issue.getLabels();
            if (labels.contains(newLabel)) {
                return true;
            }
            List<String> list = labels.stream().map(e -> e.getName()).collect(Collectors.toList());
            list.add(newLabel.getName());
            String[] labelArray = list.toArray(new String[list.size()]);
            issue.setLabels(labelArray);
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            return false;
        }
        return true;
    }

    private GHLabel validAndGetLabel(GHRepository repository, Label label, List<GHLabel> existingLabels) throws IOException {
        for (GHLabel exsitingLabel : existingLabels) {
            if (!exsitingLabel.getName().equalsIgnoreCase(label.getName())) continue;
            return exsitingLabel;
        }
        return null;
    }

    public boolean removeLabel(PullRequest pullRequest, Label label) {
        URL url = pullRequest.getURL();
        String labelName = label.getName();
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(pullRequestId);
            Collection labels = issue.getLabels();
            for (GHLabel l : labels) {
                if (!l.getName().equalsIgnoreCase(labelName)) continue;
                List<String> list = labels.stream().map(e -> e.getName()).collect(Collectors.toList());
                list.remove(l.getName());
                String[] labelArray = list.toArray(new String[list.size()]);
                issue.setLabels(labelArray);
                return true;
            }
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            return false;
        }
        Utils.logWarnMessage((Log)LOG, (String)("No label exists with name '" + labelName + "' at repository '" + repositoryId + "'"));
        return false;
    }

    public CommitStatus getCommitStatus(PullRequest pullRequest) {
        URL url = pullRequest.getURL();
        CommitStatus status = null;
        int pullRequestId = Integer.parseInt(pullRequest.getId());
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHCommitState sta;
            List statuses;
            String sha = null;
            GHRepository repository = this.github.getRepository(repositoryId);
            GHPullRequest ghPullRequest = repository.getPullRequest(pullRequestId);
            List commits = ghPullRequest.listCommits().asList();
            if (commits.size() > 0) {
                sha = ((GHPullRequestCommitDetail)commits.get(commits.size() - 1)).getSha();
            }
            if ((statuses = repository.listCommitStatuses(sha).asList()).size() > 0 && (sta = GithubUtils.getCombineStatus(statuses)) != null) {
                status = CommitStatus.fromString((String)sta.toString());
            }
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            return CommitStatus.UNKNOWN;
        }
        if (status != null) {
            return status;
        }
        return CommitStatus.UNKNOWN;
    }

    public boolean repositoryAccessable(URL url) {
        if (url.toString().contains("svn.jboss.org")) {
            Utils.logWarnMessage((Log)LOG, (String)("svn repository : " + url + " is not supported."));
            return false;
        }
        String repositoryId = RepositoryUtils.createRepositoryIdFromUrl((URL)url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            repository.getBranches();
        }
        catch (IOException e) {
            Utils.logWarnMessage((Log)LOG, (String)("repository : " + url + " is not accessable due to " + e.getMessage() + ". Check repository link and your account permission."));
            return false;
        }
        return true;
    }

    protected Log getLog() {
        return LOG;
    }
}

