/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import com.atlassian.jira.rest.client.api.domain.IssueLink;
import com.atlassian.jira.rest.client.api.domain.IssueLinkType;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.TimeTracking;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.Flag;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.IssueEstimation;
import org.jboss.set.aphrodite.domain.IssueType;
import org.jboss.set.aphrodite.domain.Release;
import org.jboss.set.aphrodite.domain.Stage;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraFields;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssue;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssueResolution;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssueTracker;
import org.jboss.set.aphrodite.spi.NotFoundException;

class IssueWrapper {
    private static final Log LOG = LogFactory.getLog(JiraIssueTracker.class);
    private static final String NAME_FIELD_ATTRIBUTE = "name=";

    IssueWrapper() {
    }

    Issue jiraSearchIssueToIssue(URL baseURL, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        URL url = this.trackerIdToBrowsableUrl(baseURL, jiraIssue.getKey());
        return this.jiraIssueToIssue(url, jiraIssue);
    }

    private void setCreationTime(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        issue.setCreationTime(jiraIssue.getCreationDate().toDate());
    }

    private void setLastUpdated(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        issue.setLastUpdated(jiraIssue.getUpdateDate().toDate());
    }

    Issue jiraIssueToIssue(URL url, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        JiraIssue issue = new JiraIssue(url);
        this.copy(url, jiraIssue, issue);
        return issue;
    }

    void copy(URL url, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue, JiraIssue issue) {
        issue.setTrackerId(jiraIssue.getKey());
        issue.setSummary(jiraIssue.getSummary());
        issue.setDescription(jiraIssue.getDescription());
        issue.setStatus(JiraFields.getAphroditeStatus(jiraIssue.getStatus().getName()));
        issue.setPriority(JiraFields.getAphroditePriority(jiraIssue.getPriority().getName()));
        TimeTracking timeTracking = jiraIssue.getTimeTracking();
        if (timeTracking != null) {
            int estimate = timeTracking.getOriginalEstimateMinutes() == null ? 0 : timeTracking.getOriginalEstimateMinutes();
            int spent = timeTracking.getTimeSpentMinutes() == null ? 0 : timeTracking.getTimeSpentMinutes();
            issue.setEstimation(new IssueEstimation((double)estimate / 60.0, (double)spent / 60.0));
        }
        this.setIssueStream(issue, jiraIssue);
        this.setIssueProject(issue, jiraIssue);
        this.setIssueComponent(issue, jiraIssue);
        this.setIssueUser((i, u) -> i.setAssignee(new org.jboss.set.aphrodite.domain.User(u.getEmailAddress(), u.getName())), issue, jiraIssue.getAssignee());
        this.setIssueUser((i, u) -> i.setReporter(new org.jboss.set.aphrodite.domain.User(u.getEmailAddress(), u.getName())), issue, jiraIssue.getReporter());
        this.setIssueStage(issue, jiraIssue);
        this.setIssueType(issue, jiraIssue);
        IssueWrapper.setIssueAffectedVersions(issue, jiraIssue);
        this.setIssueReleases(issue, jiraIssue);
        this.setIssueDependencies(url, issue, jiraIssue.getIssueLinks());
        this.setIssueComments(issue, jiraIssue);
        this.setCreationTime(issue, jiraIssue);
        this.setLastUpdated(issue, jiraIssue);
        this.setPullRequests(issue, jiraIssue);
        this.setIssueSprintRelease(issue, jiraIssue);
        this.setResolution(issue, jiraIssue);
    }

    private void setResolution(JiraIssue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        if (jiraIssue.getResolution() != null && !"".equals(jiraIssue.getResolution())) {
            if (!JiraIssueResolution.hasId(jiraIssue.getResolution().getId())) {
                String msg = String.format("Could not convert issue resolution: %1$s (%2$s) for issue: %3$s", jiraIssue.getResolution().getName(), jiraIssue.getResolution().getId(), jiraIssue.getKey());
                Utils.logWarnMessage((Log)LOG, (String)msg);
            } else {
                issue.setResolution(JiraIssueResolution.getById(jiraIssue.getResolution().getId()));
            }
        } else {
            issue.setResolution(JiraIssueResolution.UNRESOLVED);
        }
    }

    private static void setIssueAffectedVersions(JiraIssue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        if (jiraIssue.getAffectedVersions() != null) {
            ArrayList<String> affectedVersion = new ArrayList<String>(0);
            for (Version version : jiraIssue.getAffectedVersions()) {
                affectedVersion.add(version.getName());
            }
            issue.setAffectedVersions(affectedVersion);
        }
    }

    IssueInput issueToFluentUpdate(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue, Project project) throws NotFoundException {
        this.checkUnsupportedUpdateFields(issue);
        IssueInputBuilder inputBuilder = new IssueInputBuilder(jiraIssue.getProject().getKey(), jiraIssue.getIssueType().getId());
        issue.getSummary().ifPresent(arg_0 -> ((IssueInputBuilder)inputBuilder).setSummary(arg_0));
        inputBuilder.setFieldInput(new FieldInput(IssueFieldId.COMPONENTS_FIELD, issue.getComponents().stream().map(e -> ComplexIssueInputFieldValue.with((String)"name", (Object)e)).collect(Collectors.toList())));
        issue.getDescription().ifPresent(arg_0 -> ((IssueInputBuilder)inputBuilder).setDescription(arg_0));
        issue.getAssignee().ifPresent(assignee -> inputBuilder.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)ComplexIssueInputFieldValue.with((String)"name", assignee.getName().orElseThrow(this::nullUsername)))));
        issue.getStage().getStateMap().entrySet().stream().filter(entry -> entry.getValue() != FlagStatus.NO_SET).forEach(entry -> inputBuilder.setFieldInput(new FieldInput("customfield_" + (String)JiraFields.FLAG_MAP.get(entry.getKey()), (Object)((FlagStatus)entry.getValue()).getSymbol())));
        Map<String, Version> versionsMap = StreamSupport.stream(project.getVersions().spliterator(), false).collect(Collectors.toMap(Version::getName, Function.identity()));
        this.updateFixVersions(issue, versionsMap, inputBuilder);
        this.updateStreamStatus(issue, jiraIssue, versionsMap, inputBuilder);
        return inputBuilder.build();
    }

    private void updateStreamStatus(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue, Map<String, Version> versionsMap, IssueInputBuilder inputBuilder) throws NotFoundException {
        String customField = "customfield_12311240";
        IssueField issueField = jiraIssue.getField(customField);
        if (issueField == null || issueField.getType() == null && issueField.getValue() == null) {
            String msg = String.format("Unable to set a stream status for issue %1$s as %2$s projects do not utilise field: %3$s", jiraIssue.getKey(), jiraIssue.getProject().getName(), customField);
            Utils.logWarnMessage((Log)LOG, (String)msg);
            return;
        }
        for (Map.Entry entry : issue.getStreamStatus().entrySet()) {
            if (entry.getValue() == FlagStatus.ACCEPTED) continue;
            String streamName = (String)entry.getKey();
            Version version = versionsMap.get(streamName);
            if (version != null) {
                inputBuilder.setFieldInput(new FieldInput(customField, (Object)ComplexIssueInputFieldValue.with((String)"value", (Object)version.getId())));
                continue;
            }
            throw new NotFoundException("No Stream exists for this project with the name : " + streamName);
        }
    }

    private void updateFixVersions(Issue issue, Map<String, Version> versionsMap, IssueInputBuilder inputBuilder) throws NotFoundException {
        ArrayList<Version> projectVersions = new ArrayList<Version>();
        for (Release release : issue.getReleases()) {
            String releaseName = release.getVersion().orElse(null);
            Version version = versionsMap.get(releaseName);
            if (version != null) {
                projectVersions.add(version);
                continue;
            }
            throw new NotFoundException("No Release exists for this project with name : " + releaseName);
        }
        inputBuilder.setFixVersions(projectVersions);
    }

    private void checkUnsupportedUpdateFields(Issue issue) {
        if (issue.getReporter().isPresent() && LOG.isDebugEnabled()) {
            LOG.debug((Object)"JIRA does not support updating the reporter field, field ignored.");
        }
    }

    private void setIssueProject(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        BasicProject project = jiraIssue.getProject();
        if (project != null) {
            issue.setProduct(project.getName());
        }
    }

    private void setIssueComponent(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        Iterable components = jiraIssue.getComponents();
        ArrayList<String> tmp = new ArrayList<String>();
        for (BasicComponent component : components) {
            tmp.add(component.getName());
        }
        issue.setComponents(tmp);
    }

    private IllegalArgumentException nullUsername() {
        throw new IllegalArgumentException("JIRA issues require a non-null username in order to set an assignee/reporter");
    }

    private void setIssueUser(BiConsumer<Issue, User> function, Issue issue, User user) {
        if (user != null && user.getName() != null && user.getEmailAddress() != null) {
            function.accept(issue, user);
        }
    }

    private void setIssueStage(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        Stage stage = new Stage();
        this.setFlag(jiraIssue, stage, Flag.PM, "customfield_12311242");
        this.setFlag(jiraIssue, stage, Flag.DEV, "customfield_12311243");
        this.setFlag(jiraIssue, stage, Flag.QE, "customfield_12311244");
        issue.setStage(stage);
    }

    private void setFlag(com.atlassian.jira.rest.client.api.domain.Issue jiraIssue, Stage stage, Flag flag, String fieldname) {
        if (jiraIssue.getField(fieldname) != null && jiraIssue.getField(fieldname).getValue() != null) {
            stage.setStatus(flag, FlagStatus.getMatchingFlag((String)((String)jiraIssue.getField(fieldname).getValue())));
        }
    }

    private void setIssueType(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        String type = jiraIssue.getIssueType().getName();
        issue.setType(this.getIssueType(type));
    }

    private IssueType getIssueType(String type) {
        switch (type = type.trim().replaceAll(" +", " ")) {
            case "SUPPORT PATCH": {
                return IssueType.ONE_OFF;
            }
            case "PATCH": {
                return IssueType.SUPPORT_PATCH;
            }
        }
        return IssueType.getMatchingIssueType((String)type);
    }

    private void setIssueSprintRelease(JiraIssue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        JSONArray fieldValue;
        IssueField issueField = jiraIssue.getFieldByName("Sprint");
        if (issueField != null && issueField.getValue() != null && (fieldValue = (JSONArray)issueField.getValue()).length() > 0) {
            issue.setSprintRelease(this.extractSprintName(fieldValue));
        }
    }

    private String extractSprintName(JSONArray fieldValue) {
        try {
            String value = (String)fieldValue.get(0);
            value = value.substring(value.indexOf(NAME_FIELD_ATTRIBUTE));
            return value.substring(NAME_FIELD_ATTRIBUTE.length(), value.indexOf(44));
        }
        catch (JSONException e) {
            return "";
        }
    }

    private void setIssueStream(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        try {
            IssueField jsonField = jiraIssue.getField("customfield_12311240");
            if (jsonField == null || jsonField.getValue() == null) {
                return;
            }
            JSONObject value = (JSONObject)jsonField.getValue();
            Map<String, FlagStatus> streamStatus = Collections.singletonMap(value.getString("name"), FlagStatus.ACCEPTED);
            issue.setStreamStatus(streamStatus);
        }
        catch (JSONException e) {
            LOG.error((Object)("error setting the stream in " + jiraIssue.getKey()), (Throwable)e);
        }
    }

    private void setIssueReleases(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        Iterable versions = jiraIssue.getFixVersions();
        if (versions != null) {
            List releases = StreamSupport.stream(jiraIssue.getFixVersions().spliterator(), false).map(version -> new Release(version.getName())).collect(Collectors.toList());
            issue.setReleases(releases);
        }
    }

    private void setIssueDependencies(URL originalUrl, Issue issue, Iterable<IssueLink> links) {
        if (links == null) {
            return;
        }
        for (IssueLink il : links) {
            URL url;
            if (il.getIssueLinkType().getDirection().equals((Object)IssueLinkType.Direction.INBOUND)) {
                url = this.trackerIdToBrowsableUrl(originalUrl, il.getTargetIssueKey());
                issue.getBlocks().add(url);
                continue;
            }
            url = this.trackerIdToBrowsableUrl(originalUrl, il.getTargetIssueKey());
            issue.getDependsOn().add(url);
        }
    }

    private void setIssueComments(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        ArrayList comments = new ArrayList();
        jiraIssue.getComments().forEach(c -> comments.add(new Comment((String)issue.getTrackerId().get(), Long.toString(c.getId()), c.getBody(), false)));
        issue.getComments().addAll(comments);
    }

    private void setPullRequests(JiraIssue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        IssueField fieldContent = jiraIssue.getFieldByName("Git Pull Request");
        if (fieldContent != null) {
            IssueWrapper.extractPullRequests(issue, (JSONArray)fieldContent.getValue());
        }
    }

    private static void extractPullRequests(JiraIssue issue, JSONArray urls) {
        if (urls != null && urls.length() > 0) {
            ArrayList<URL> prUrls = new ArrayList<URL>(urls.length());
            for (int index = 0; index < urls.length(); ++index) {
                prUrls.add(Utils.createURL((String)IssueWrapper.getFromJSONArray(index, urls).toString()));
            }
            issue.setPullRequests(prUrls);
        }
    }

    private static Object getFromJSONArray(int i, JSONArray urls) {
        try {
            return urls.get(i);
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private URL trackerIdToBrowsableUrl(URL url, String trackerId) {
        try {
            String link = url.getProtocol() + "://" + url.getHost() + "/browse/" + trackerId;
            return new URL(link);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

