/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Filter;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Session;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import io.atlassian.util.concurrent.Promise;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.IssueTrackerConfig;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Release;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.issue.trackers.common.AbstractIssueTracker;
import org.jboss.set.aphrodite.issue.trackers.common.IssueCreationDetails;
import org.jboss.set.aphrodite.issue.trackers.jira.IssueWrapper;
import org.jboss.set.aphrodite.issue.trackers.jira.JIRAIssueCreationDetails;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraFields;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraQueryBuilder;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class JiraIssueTracker
extends AbstractIssueTracker {
    static final Pattern JIRAFIXVERSION = Pattern.compile("(\\d\\.)(\\d\\.)(\\d+).GA");
    private static final Log LOG = LogFactory.getLog(JiraIssueTracker.class);
    private final IssueWrapper WRAPPER = new IssueWrapper();
    private final JiraQueryBuilder queryBuilder = new JiraQueryBuilder();
    private JiraRestClient restClient;
    private static int NB_TOTAL_ISSUE_NOT_INITIATED = -1;

    public JiraIssueTracker() {
        super(TrackerType.JIRA);
    }

    public boolean init(IssueTrackerConfig config) {
        boolean parentInitiated = super.init(config);
        if (!parentInitiated) {
            return false;
        }
        try {
            AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
            URI jiraServerUri = this.baseUrl.toURI();
            this.restClient = factory.createWithBasicHttpAuthentication(jiraServerUri, config.getUsername(), config.getPassword());
            ((Session)this.restClient.getSessionClient().getCurrentSession().get()).getLoginInfo().getFailedLoginCount();
        }
        catch (Exception e) {
            Utils.logException((Log)LOG, (Exception)e);
            return false;
        }
        return true;
    }

    public Issue getIssue(URL url) throws NotFoundException {
        String issueKey = JiraIssueTracker.getIssueKey(url);
        List<IssueRestClient.Expandos> expandos = this.createExpandos();
        try {
            this.checkHost(url);
            com.atlassian.jira.rest.client.api.domain.Issue issue = (com.atlassian.jira.rest.client.api.domain.Issue)this.restClient.getIssueClient().getIssue(issueKey, expandos).get();
            return this.WRAPPER.jiraIssueToIssue(url, issue);
        }
        catch (InterruptedException e) {
            throw new NotFoundException("Something interrupted the execution when trying to retrieve issue " + issueKey, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new NotFoundException("Unable to retrieve issue with id: " + issueKey, (Throwable)e);
        }
    }

    public List<Issue> getIssues(Version version) {
        SearchCriteria sc = new SearchCriteria.Builder().setRelease(new Release(version.getName().trim())).setProduct("JBEAP").setMaxResults(Integer.valueOf(this.config.getDefaultIssueLimit())).build();
        List<Issue> issues = this.searchIssues(sc);
        return issues;
    }

    private List<IssueRestClient.Expandos> createExpandos() {
        ArrayList<IssueRestClient.Expandos> expandos = new ArrayList<IssueRestClient.Expandos>();
        expandos.add(IssueRestClient.Expandos.CHANGELOG);
        return expandos;
    }

    private com.atlassian.jira.rest.client.api.domain.Issue getIssue(Issue issue) throws NotFoundException {
        String trackerId = issue.getTrackerId().orElse(JiraIssueTracker.getIssueKey(issue.getURL()));
        return this.getIssue(trackerId);
    }

    private com.atlassian.jira.rest.client.api.domain.Issue getIssue(String trackerId) throws NotFoundException {
        try {
            return (com.atlassian.jira.rest.client.api.domain.Issue)this.restClient.getIssueClient().getIssue(trackerId).get();
        }
        catch (Exception e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    public List<Issue> getIssues(Collection<URL> urls) {
        if ((urls = this.filterUrlsByHost(urls)).isEmpty()) {
            return new ArrayList<Issue>();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (URL url : urls) {
            try {
                ids.add(JiraIssueTracker.getIssueKey(url));
            }
            catch (NotFoundException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("Unable to extract trackerId from: " + url));
            }
        }
        String jql = this.queryBuilder.getMultipleIssueJQL(ids);
        return this.searchIssues(jql, ids.size());
    }

    public List<Issue> searchIssues(SearchCriteria searchCriteria) {
        String jql = this.queryBuilder.getSearchJQL(searchCriteria);
        int maxResults = searchCriteria.getMaxResults().orElse(this.config.getDefaultIssueLimit());
        return this.searchIssues(jql, maxResults);
    }

    private List<Issue> searchIssues(String jql, int maxResults) {
        try {
            HashSet<String> fields = new HashSet<String>();
            fields.add("*all");
            return this.paginateResults(this.restClient.getSearchClient(), jql, fields, maxResults);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Issue> paginateResults(SearchRestClient searchClient, String jql, Set<String> fields, int maxResults) throws InterruptedException, ExecutionException {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        int startPosition = 0;
        int nbTotalIssue = NB_TOTAL_ISSUE_NOT_INITIATED;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Max Results:" + maxResults));
        }
        do {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Start Position:" + startPosition));
            }
            SearchResult result = (SearchResult)searchClient.searchJql(jql, Integer.valueOf(maxResults), Integer.valueOf(startPosition), fields).get();
            if (nbTotalIssue == NB_TOTAL_ISSUE_NOT_INITIATED) {
                nbTotalIssue = result.getTotal();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Total Issues in result:" + nbTotalIssue));
                }
            }
            result.getIssues().forEach(issue -> issues.add(this.WRAPPER.jiraSearchIssueToIssue(this.baseUrl, (com.atlassian.jira.rest.client.api.domain.Issue)issue)));
        } while ((startPosition += maxResults) < nbTotalIssue);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Total issues:" + issues.size()));
        }
        return issues;
    }

    public List<Issue> searchIssuesByFilter(URL filterUrl) throws NotFoundException {
        String jql = this.getJQLFromFilter(filterUrl);
        return this.searchIssues(jql, this.config.getDefaultIssueLimit());
    }

    private String getJQLFromFilter(URL filterUrl) throws NotFoundException {
        try {
            SearchRestClient searchClient = this.restClient.getSearchClient();
            Filter filter = (Filter)searchClient.getFilter(filterUrl.toURI()).get();
            return filter.getJql();
        }
        catch (Exception e) {
            throw new NotFoundException("Unable to retrieve filter with url: " + filterUrl, (Throwable)e);
        }
    }

    public boolean updateIssue(Issue issue) throws NotFoundException, AphroditeException {
        try {
            this.checkHost(issue.getURL());
            com.atlassian.jira.rest.client.api.domain.Issue jiraIssue = this.getIssue(issue);
            Project project = (Project)this.restClient.getProjectClient().getProject(jiraIssue.getProject().getSelf()).claim();
            IssueInput update = this.WRAPPER.issueToFluentUpdate(issue, jiraIssue, project);
            IssueRestClient issueClient = this.restClient.getIssueClient();
            issueClient.updateIssue(jiraIssue.getKey(), update).claim();
            if (!JiraFields.hasSameIssueStatus(issue, jiraIssue)) {
                String transition = JiraFields.getJiraTransition(issue, jiraIssue);
                for (Transition t : (Iterable)issueClient.getTransitions(jiraIssue).get()) {
                    if (!t.getName().equals(transition)) continue;
                    issueClient.transition(jiraIssue, new TransitionInput(t.getId())).claim();
                }
            }
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AphroditeException(this.getUpdateErrorMessage(issue, e), (Throwable)e);
        }
    }

    private String toKey(URL url) {
        try {
            return JiraIssueTracker.getIssueKey(url);
        }
        catch (NotFoundException e) {
            return "";
        }
    }

    public void addCommentToIssue(Issue issue, org.jboss.set.aphrodite.domain.Comment comment) throws NotFoundException {
        super.addCommentToIssue(issue, comment);
        this.postComment(issue, comment);
    }

    private void postComment(Issue issue, org.jboss.set.aphrodite.domain.Comment comment) throws NotFoundException {
        if (comment.isPrivate()) {
            Utils.logWarnMessage((Log)LOG, (String)("Private comments are not currently supported by " + ((Object)((Object)this)).getClass().getName()));
        }
        com.atlassian.jira.rest.client.api.domain.Issue jiraIssue = this.getIssue(issue);
        Comment c = Comment.valueOf((String)comment.getBody());
        this.restClient.getIssueClient().addComment(jiraIssue.getCommentsUri(), c).claim();
    }

    public boolean addCommentToIssue(Map<Issue, org.jboss.set.aphrodite.domain.Comment> commentMap) {
        commentMap = this.filterIssuesByHost(commentMap);
        List requests = commentMap.entrySet().stream().map(entry -> CompletableFuture.supplyAsync(() -> this.postCommentAndLogExceptions((Issue)entry.getKey(), (org.jboss.set.aphrodite.domain.Comment)entry.getValue()), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).noneMatch(failed -> failed == false);
    }

    public boolean addCommentToIssue(Collection<Issue> issues, org.jboss.set.aphrodite.domain.Comment comment) {
        issues = this.filterIssuesByHost(issues);
        List requests = issues.stream().map(issue -> CompletableFuture.supplyAsync(() -> this.postCommentAndLogExceptions((Issue)issue, comment), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).noneMatch(failed -> failed == false);
    }

    private boolean postCommentAndLogExceptions(Issue issue, org.jboss.set.aphrodite.domain.Comment comment) {
        try {
            this.postComment(issue, comment);
            return true;
        }
        catch (NotFoundException e) {
            Utils.logException((Log)LOG, (Exception)((Object)e));
            return false;
        }
    }

    public Log getLog() {
        return LOG;
    }

    static String getIssueKey(URL url) throws NotFoundException {
        String path = JiraIssueTracker.correctPath(url.getPath());
        boolean api = path.contains("/rest/api/2/issue/");
        boolean browse = path.contains("/browse/");
        if (!api && !browse) {
            throw new NotFoundException("The URL path must be of the form '/rest/api/2/issue/' OR '/browse/'");
        }
        return api ? path.substring("/rest/api/2/issue/".length()) : path.substring("/browse/".length());
    }

    static String correctPath(String path) {
        Matcher m = JiraFields.PROJECTS_ISSUE_PATTERN.matcher(path);
        if (m.find()) {
            return m.replaceFirst("/browse/");
        }
        return path;
    }

    private String getUpdateErrorMessage(Issue issue, Exception e) {
        String msg = e.getMessage();
        if (msg.contains("does not exist or read-only")) {
            for (Map.Entry entry : JiraFields.FLAG_MAP.entrySet()) {
                if (!msg.contains((CharSequence)entry.getValue())) continue;
                String retMsg = "Flag '%1$s' set in Issue.stage cannot be set for %2$s '%3$s'";
                return this.getOptionalErrorMessage(retMsg, issue.getProduct(), entry.getKey(), issue.getURL());
            }
            if (msg.contains("12311240")) {
                String retMsg = "Release.milestone cannot be set for %2$s ''%3$s'";
                return this.getOptionalErrorMessage(retMsg, issue.getProduct(), null, issue.getURL());
            }
        }
        return null;
    }

    private String getOptionalErrorMessage(String template, Optional<?> optional, Object val, URL url) {
        if (optional.isPresent()) {
            return String.format(template, val, "issues in project", optional.get());
        }
        return String.format(template, val, "issue at ", url);
    }

    public void destroy() {
        try {
            this.restClient.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"destroyin jira issue tracker", (Throwable)e);
        }
    }

    public boolean isCPReleased(String cpVersion) {
        Matcher matcher = JIRAFIXVERSION.matcher(cpVersion);
        if (!matcher.matches()) {
            return false;
        }
        Promise promise = this.restClient.getProjectClient().getProject("JBEAP");
        Project project = (Project)promise.claim();
        Optional<Version> version = StreamSupport.stream(project.getVersions().spliterator(), false).filter(v -> v.getName().equals(cpVersion)).findAny();
        if (version.isPresent()) {
            return version.get().isReleased();
        }
        return false;
    }

    public Iterable<Version> getVersionsByProject(String projectName) {
        return ((Project)this.restClient.getProjectClient().getProject(projectName).claim()).getVersions();
    }

    public Issue createIssue(IssueCreationDetails details) throws MalformedURLException, NotFoundException, AphroditeException {
        assert (details != null);
        assert (details instanceof JIRAIssueCreationDetails);
        JIRAIssueCreationDetails localDetails = (JIRAIssueCreationDetails)details;
        assert (details.getTrackerURL() != null);
        assert (details.getProjectKey() != null);
        assert (details.getDescription() != null);
        assert (localDetails.getIssueType() != null);
        IssueInputBuilder builder = new IssueInputBuilder(localDetails.getProjectKey(), localDetails.getIssueType(), localDetails.getDescription());
        if (localDetails.isSecuritySensitiveIssue()) {
            builder.setFieldValue("customfield_12311640", Arrays.asList(ComplexIssueInputFieldValue.with((String)"id", (Object)"10650")));
        }
        if (localDetails.getSecurityLevel() != null) {
            String id = JiraFields.getSecurityLevelId(localDetails.getSecurityLevel());
            builder.setFieldValue("security", ComplexIssueInputFieldValue.with((String)"id", (Object)id));
        }
        IssueInput newIssue = builder.build();
        BasicIssue basicIssue = (BasicIssue)this.restClient.getIssueClient().createIssue(newIssue).claim();
        URL trackerURL = localDetails.getTrackerURL();
        if (trackerURL.toString().endsWith("browse") || trackerURL.toString().endsWith("browse/")) {
            return this.getIssue(new URL(trackerURL, basicIssue.getKey()));
        }
        return this.getIssue(new URL(trackerURL, "browse/" + basicIssue.getKey()));
    }

    public void linkIssues(Issue from, Issue to, String linkType) {
        LinkIssuesInput link = new LinkIssuesInput(this.toKey(from.getURL()), this.toKey(to.getURL()), linkType);
        this.restClient.getIssueClient().linkIssue(link).claim();
    }
}

