/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jboss.set.aphrodite.domain.Flag;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraFields;

class JiraQueryBuilder {
    JiraQueryBuilder() {
    }

    String getSearchJQL(SearchCriteria criteria) {
        StringBuilder sb = new StringBuilder();
        criteria.getStatus().ifPresent(status -> this.addCriteriaToJQL("status = ", JiraFields.getJiraStatus(status), " AND ", sb));
        criteria.getAssignee().ifPresent(assignee -> this.addCriteriaToJQL("assignee = ", assignee, " AND ", sb));
        criteria.getReporter().ifPresent(reporter -> this.addCriteriaToJQL("reporter = ", reporter, " AND ", sb));
        criteria.getComponent().ifPresent(component -> this.addCriteriaToJQL("component = ", component, " AND ", sb));
        criteria.getProduct().ifPresent(product -> this.addCriteriaToJQL("project = ", product, " AND ", sb));
        criteria.getLastUpdated().ifPresent(date -> {
            String formattedDate = date.atStartOfDay().format(DateTimeFormatter.ISO_LOCAL_DATE);
            this.addCriteriaToJQL("updated >= ", formattedDate, " AND ", sb);
        });
        criteria.getRelease().ifPresent(release -> {
            if (release.getVersion().isPresent()) {
                this.addCriteriaToJQL("fixVersion = ", release.getVersion().orElse(null), " AND ", sb);
            } else {
                sb.append(" AND fixVersion is EMPTY");
            }
            this.addCriteriaToJQL(JiraFields.getJQLField("12311240") + " = ", release.getMilestone().orElse(null), " AND ", sb);
        });
        criteria.getStage().ifPresent(stage -> stage.getStateMap().entrySet().stream().filter(entry -> entry.getValue() != FlagStatus.NO_SET).forEach(entry -> this.addCriteriaToJQL((String)JiraFields.CUSTOM_FIELD_MAP.get((Object)((Flag)entry.getKey()).toString()) + " = ", ((FlagStatus)entry.getValue()).getSymbol(), " AND ", sb)));
        criteria.getLabels().forEach(label -> this.addCriteriaToJQL("labels = ", label, " AND ", sb));
        return sb.toString();
    }

    String getMultipleIssueJQL(List<String> ids) {
        StringBuilder sb = new StringBuilder();
        ids.forEach(id -> this.addCriteriaToJQL("id = ", id, " OR ", sb));
        return sb.toString();
    }

    private void addCriteriaToJQL(String criteria, Object value, String connector, StringBuilder sb) {
        if (criteria == null || value == null) {
            return;
        }
        if (connector != null && sb.length() != 0) {
            sb.append(connector);
        }
        sb.append(criteria);
        sb.append("'");
        sb.append(value);
        sb.append("'");
    }
}

