/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.regex.Pattern;
import org.jboss.set.aphrodite.domain.Flag;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.IssuePriority;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.spi.AphroditeException;

class JiraFields {
    static final String API_BASE_PATH = "/rest/api/2/";
    static final String API_ISSUE_PATH = "/rest/api/2/issue/";
    static final String BROWSE_ISSUE_PATH = "/browse/";
    static final Pattern PROJECTS_ISSUE_PATTERN = Pattern.compile("\\/projects\\/[^\\/]+\\/issues\\/");
    static final String DATE_STRING_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZZ";
    static final String JSON_CUSTOM_FIELD = "customfield_";
    static final String JQL_CUSTOM_TEMPLATE = "cf[%s]";
    static final String PM_ACK = "12311242";
    static final String DEV_ACK = "12311243";
    static final String QE_ACK = "12311244";
    static final String TARGET_RELEASE = "12311240";
    static final BiMap<String, String> CUSTOM_FIELD_MAP = new ImmutableBiMap.Builder().put((Object)Flag.DEV.toString(), (Object)JiraFields.getJQLField("12311243")).put((Object)Flag.PM.toString(), (Object)JiraFields.getJQLField("12311242")).put((Object)Flag.QE.toString(), (Object)JiraFields.getJQLField("12311244")).put((Object)"TARGET_RELEASE", (Object)JiraFields.getJQLField("12311240")).build();
    static final BiMap<String, IssueStatus> STATUS_MAP = new ImmutableBiMap.Builder().put((Object)"new", (Object)IssueStatus.CREATED).put((Object)"open", (Object)IssueStatus.NEW).put((Object)"coding in progress", (Object)IssueStatus.ASSIGNED).put((Object)"pull request sent", (Object)IssueStatus.POST).put((Object)"resolved", (Object)IssueStatus.MODIFIED).put((Object)"ready for qa", (Object)IssueStatus.ON_QA).put((Object)"verified", (Object)IssueStatus.VERIFIED).put((Object)"closed", (Object)IssueStatus.CLOSED).build();
    static final BiMap<String, IssuePriority> PRIORITY_MAP = JiraFields.initPriorityMap();
    static final BiMap<Flag, String> FLAG_MAP = new ImmutableBiMap.Builder().put((Object)Flag.DEV, (Object)"12311243").put((Object)Flag.PM, (Object)"12311242").put((Object)Flag.QE, (Object)"12311244").build();

    JiraFields() {
    }

    static BiMap<String, IssuePriority> initPriorityMap() {
        ImmutableBiMap.Builder mapBuilder = new ImmutableBiMap.Builder();
        for (IssuePriority priority : IssuePriority.values()) {
            mapBuilder.put((Object)priority.toString().toLowerCase(), (Object)priority);
        }
        return mapBuilder.build();
    }

    static IssueStatus getAphroditeStatus(String status) {
        IssueStatus issueStatus = (IssueStatus)STATUS_MAP.get((Object)(status = status.toLowerCase()));
        if (issueStatus == null) {
            switch (status) {
                case "reopened": {
                    return IssueStatus.NEW;
                }
                case "qa in progress": {
                    return IssueStatus.ON_QA;
                }
            }
            return IssueStatus.UNDEFINED;
        }
        return issueStatus;
    }

    static IssuePriority getAphroditePriority(String priority) {
        IssuePriority issueStatus = (IssuePriority)PRIORITY_MAP.get((Object)priority.toLowerCase());
        return issueStatus == null ? IssuePriority.UNDEFINED : issueStatus;
    }

    static String getJiraStatus(IssueStatus status) {
        return (String)STATUS_MAP.inverse().get((Object)status);
    }

    static String getJQLField(String field) {
        return String.format(JQL_CUSTOM_TEMPLATE, field);
    }

    static boolean hasSameIssueStatus(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) {
        IssueStatus jiraStatus;
        IssueStatus status = issue.getStatus();
        return status == (jiraStatus = JiraFields.getAphroditeStatus(jiraIssue.getStatus().getName()));
    }

    static String getJiraTransition(Issue issue, com.atlassian.jira.rest.client.api.domain.Issue jiraIssue) throws AphroditeException {
        IssueStatus currentStatus = JiraFields.getAphroditeStatus(jiraIssue.getStatus().getName());
        return JiraFields.getJiraTransition(currentStatus, issue.getStatus());
    }

    static String getJiraTransition(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (currentStatus) {
            case CREATED: {
                return JiraFields.transitionsForCreatedStatus(currentStatus, newStatus);
            }
            case NEW: {
                return JiraFields.transitionsForNewStatus(currentStatus, newStatus);
            }
            case ASSIGNED: {
                return JiraFields.transitionsForAssignedStatus(currentStatus, newStatus);
            }
            case POST: {
                return JiraFields.transitionsForPostStatus(currentStatus, newStatus);
            }
            case MODIFIED: {
                return JiraFields.transitionsForModifiedStatus(currentStatus, newStatus);
            }
            case ON_QA: {
                return JiraFields.transitionsForON_QAStatus(currentStatus, newStatus);
            }
            case VERIFIED: {
                return JiraFields.transitionsForVerifiedStatus(currentStatus, newStatus);
            }
            case CLOSED: {
                return JiraFields.transitionsForClosedStatus(currentStatus, newStatus);
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus);
    }

    private static String transitionsForCreatedStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case CREATED: {
                return "Devel Approve";
            }
            case NEW: {
                return "Hand Over to Development";
            }
            case CLOSED: {
                return "Close Issue";
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus);
    }

    private static String transitionsForNewStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case CREATED: {
                return "Back To New";
            }
            case ASSIGNED: {
                return "Start Progress";
            }
            case POST: {
                return "Link Pull Request";
            }
            case MODIFIED: {
                return "Resolve Issue";
            }
            case CLOSED: {
                return "Close Issue";
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus + " to " + newStatus);
    }

    private static String transitionsForAssignedStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case CREATED: {
                return "Back To New";
            }
            case NEW: {
                return "Stop Progress";
            }
        }
        return JiraFields.transitionsForNewStatus(currentStatus, newStatus);
    }

    private static String transitionsForPostStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case CREATED: {
                return "Back To New";
            }
            case MODIFIED: {
                return "Resolve Issue";
            }
            case ASSIGNED: {
                return "Start Progress";
            }
            case POST: {
                return "Update Pull Request";
            }
            case NEW: {
                return "Reject Pull Request";
            }
            case CLOSED: {
                return "Close Issue";
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus + " to " + newStatus);
    }

    private static String transitionsForModifiedStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case CREATED: {
                return "Back To New";
            }
            case NEW: 
            case ASSIGNED: {
                return "Reopen Issue";
            }
            case ON_QA: {
                return "Hand Over to QA";
            }
            case CLOSED: {
                return "Close Issue";
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus + " to " + newStatus);
    }

    private static String transitionsForON_QAStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case CREATED: {
                return "Back To New";
            }
            case NEW: 
            case ASSIGNED: {
                return "Reopen Issue From QA";
            }
            case VERIFIED: {
                return "Verify Issue";
            }
            case CLOSED: {
                return "Close Issue";
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus + " to " + newStatus);
    }

    private static String transitionsForVerifiedStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case CREATED: {
                return "Back To New";
            }
            case NEW: 
            case ASSIGNED: {
                return "Reopen Issue";
            }
            case ON_QA: {
                return "Retest";
            }
            case CLOSED: {
                return "Close Issue";
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus + " to " + newStatus);
    }

    private static String transitionsForClosedStatus(IssueStatus currentStatus, IssueStatus newStatus) throws AphroditeException {
        switch (newStatus) {
            case NEW: 
            case ASSIGNED: {
                return "Reopen Issue";
            }
        }
        throw new AphroditeException("It's not possible to transition from " + currentStatus + " to " + newStatus);
    }
}

