/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.set.aphrodite.jira.rest.client.api.domain.Sprint;

public class SprintParser
implements JsonObjectParser<Sprint> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public Sprint parse(JSONObject json) throws JSONException {
        Long id = JsonParseUtil.getOptionalLong((JSONObject)json, (String)"id");
        URI self = JsonParseUtil.getSelfUri((JSONObject)json);
        String state = json.getString("state");
        String name = json.getString("name");
        Date startDate = SprintParser.parseDateTime(json.getString("startDate"));
        Date endDate = SprintParser.parseDateTime(json.getString("endDate"));
        Date completeDate = SprintParser.parseDateTime(json.optString("completeDate", null));
        Integer originBoardId = JsonParseUtil.parseOptionInteger((JSONObject)json, (String)"originBoardId");
        return new Sprint(self, id, state, name, startDate, endDate, completeDate, originBoardId);
    }

    private static Date parseDateTime(String source) throws JSONException {
        if (source == null) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(source);
        }
        catch (ParseException e) {
            throw new JSONException((Throwable)e);
        }
    }
}

