/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.jboss.set.aphrodite.jira.rest.client.api.domain.Board;
import org.jboss.set.aphrodite.jira.rest.client.api.domain.Page;
import org.jboss.set.aphrodite.jira.rest.client.api.domain.Sprint;
import org.jboss.set.aphrodite.jira.rest.client.internal.json.BoardParser;
import org.jboss.set.aphrodite.jira.rest.client.internal.json.PageParser;
import org.jboss.set.aphrodite.jira.rest.client.internal.json.SprintParser;

public class AsynchronousAgileRestClient
extends AbstractAsynchronousRestClient {
    private final JsonObjectParser<Board> boardParser = new BoardParser();
    private final JsonObjectParser<Page<Board>> boardsParser = new PageParser<Board>(this.boardParser);
    private final JsonObjectParser<Sprint> sprintParser = new SprintParser();
    private final JsonObjectParser<Page<Sprint>> sprintPageParser = new PageParser<Sprint>(this.sprintParser);
    private final URI baseUri;

    public AsynchronousAgileRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    public Promise<Page<Board>> getAllBoards(Long startAt, Integer maxResults, @Deprecated String type, String name, String projectKeyOrId) {
        UriBuilder builder = UriBuilder.fromUri((URI)this.baseUri).path("board");
        if (startAt != null) {
            builder.queryParam("startAt", new Object[]{startAt});
        }
        if (maxResults != null) {
            builder.queryParam("maxResults", new Object[]{maxResults});
        }
        if (type != null) {
            builder.queryParam("type", new Object[]{type});
        }
        if (name != null) {
            builder.queryParam("name", new Object[]{name});
        }
        if (projectKeyOrId != null) {
            builder.queryParam("projectKeyOrId", new Object[]{projectKeyOrId});
        }
        URI uri = builder.build(new Object[0]);
        return this.getAndParse(uri, (JsonParser)this.boardsParser);
    }

    public Promise<Page<Sprint>> getAllSprints(int boardId, Long startAt, Integer maxResults, @Deprecated String state) {
        UriBuilder builder = UriBuilder.fromUri((URI)this.baseUri).path("board").path(Integer.toString(boardId)).path("sprint");
        if (startAt != null) {
            builder.queryParam("startAt", new Object[]{startAt});
        }
        if (maxResults != null) {
            builder.queryParam("maxResults", new Object[]{maxResults});
        }
        if (state != null) {
            builder.queryParam("state", new Object[]{state});
        }
        URI uri = builder.build(new Object[0]);
        return this.getAndParse(uri, (JsonParser)this.sprintPageParser);
    }
}

