/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.util;

import java.util.List;
import java.util.Optional;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.IssueEstimation;
import org.jboss.set.aphrodite.domain.Stage;
import org.junit.Assert;

public class TestUtils {
    private static final double DELTA = 1.0E-15;

    public static void assertDeepEqualsIssue(Issue expected, Issue other) {
        Assert.assertEquals((String)"issue tracker id mismatch", (Object)expected.getTrackerId(), (Object)other.getTrackerId());
        Assert.assertEquals((String)"issue assignee mismatch", (Object)expected.getAssignee(), (Object)other.getAssignee());
        Assert.assertEquals((String)"issue summary mismatch", (Object)expected.getSummary(), (Object)other.getSummary());
        Assert.assertEquals((String)"issue creation time mismatch", (Object)expected.getCreationTime(), (Object)expected.getCreationTime());
        Assert.assertEquals((String)"issue description mismatch", (Object)expected.getDescription(), (Object)other.getDescription());
        Assert.assertEquals((String)"issue status mismatch", (Object)expected.getStatus(), (Object)other.getStatus());
        Assert.assertEquals((String)"issue component mismatch", (Object)expected.getComponents(), (Object)other.getComponents());
        Assert.assertEquals((String)"issue product mismatch", (Object)expected.getProduct(), (Object)other.getProduct());
        Assert.assertEquals((String)"issue type mismatch", (Object)expected.getType(), (Object)other.getType());
        List expectedReleases = expected.getReleases();
        List otherReleases = other.getReleases();
        Assert.assertTrue((String)"issue release mismatch", (boolean)expectedReleases.containsAll(otherReleases));
        Assert.assertEquals((String)"issue depends on list mismatch", (long)expected.getDependsOn().size(), (long)other.getDependsOn().size());
        Assert.assertEquals((String)"issue depends on list mismatch", (Object)expected.getDependsOn(), (Object)other.getDependsOn());
        Assert.assertEquals((String)"issue blocks list mismatch", (long)expected.getBlocks().size(), (long)other.getBlocks().size());
        Assert.assertEquals((String)"issue blocks list mismatch", (Object)expected.getBlocks(), (Object)other.getBlocks());
        Optional expectedEst = expected.getEstimation();
        Optional otherEst = other.getEstimation();
        Assert.assertEquals((String)"issue estimation mismatch", (Object)expectedEst.isPresent(), (Object)otherEst.isPresent());
        Assert.assertEquals((String)"issue estimation mismatch", (double)((IssueEstimation)expectedEst.get()).getInitialEstimate(), (double)((IssueEstimation)otherEst.get()).getInitialEstimate(), (double)1.0E-15);
        Assert.assertEquals((String)"issue estimation mismatch", (double)((IssueEstimation)expectedEst.get()).getHoursWorked(), (double)((IssueEstimation)otherEst.get()).getHoursWorked(), (double)1.0E-15);
        Stage expectedStage = expected.getStage();
        Stage otherStage = other.getStage();
        Assert.assertEquals((String)"issue stage mismatch", (long)expectedStage.getStateMap().size(), (long)otherStage.getStateMap().size());
        Assert.assertEquals((String)"issue stage mismatch", (Object)expectedStage.getStateMap(), (Object)otherStage.getStateMap());
    }
}

