/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.alignment_verification;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.io.PomIO;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;

@Mojo(name="verify", requiresProject=true, requiresDirectInvocation=true)
public class VerifyMojo
extends AbstractMojo {
    private static final String EAP_GROUPID = "org.jboss.eap";
    private static final String EAP_PARENT_ARTIFACTID = "jboss-eap-parent";
    private static final String LEGACY_BOM_ARTIFACTID = "wildfly-legacy-ee-bom";
    @Parameter(required=false, property="channelFile")
    String channelFile;
    @Parameter(property="ignoreModules", defaultValue="")
    List<String> ignoreModules;
    @Inject
    MavenSession mavenSession;
    @Inject
    MavenProject mavenProject;
    @Inject
    PomIO pomIO;
    @Inject
    DependencyCollectorBuilder dependencyCollectorBuilder;
    @Inject
    ManipulationSession manipulationSession;
    private final List<ProjectRef> ignoredModules = new ArrayList<ProjectRef>();
    private List<Project> pmeProjects;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        this.ignoreModules.forEach(ga -> this.ignoredModules.add(SimpleProjectRef.parse((String)ga)));
        List projectModules = this.mavenProject.getCollectedProjects().stream().map(p -> new SimpleProjectRef(p.getGroupId(), p.getArtifactId())).collect(Collectors.toList());
        ChannelSession channelSession = this.createChannelSession();
        HashMap<MavenProject, List> unalignedArtifacts = new HashMap<MavenProject, List>();
        try {
            this.pmeProjects = this.pomIO.parseProject(this.mavenProject.getModel().getPomFile());
            for (MavenProject module2 : this.mavenProject.getCollectedProjects()) {
                SimpleProjectRef moduleProjectRef = new SimpleProjectRef(module2.getGroupId(), module2.getArtifactId());
                if (this.ignoredModules.contains(moduleProjectRef)) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s (ignored)", module2.getGroupId(), module2.getArtifactId()));
                    continue;
                }
                if (this.isLegacyBom(module2)) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s (is legacy BOM)", module2.getGroupId(), module2.getArtifactId()));
                    continue;
                }
                if (this.dependsOnLegacyBom(module2)) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s (uses legacy BOM)", module2.getGroupId(), module2.getArtifactId()));
                    continue;
                }
                this.getLog().info((CharSequence)String.format("Processing module %s:%s", module2.getGroupId(), module2.getArtifactId()));
                DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
                buildingRequest.setProject(module2);
                DependencyNode rootNode = this.dependencyCollectorBuilder.collectDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
                CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
                rootNode.accept((DependencyNodeVisitor)visitor);
                visitor.getNodes().forEach(node -> {
                    Artifact artifact = node.getArtifact();
                    SimpleProjectRef artifactAsProjectRef = new SimpleProjectRef(artifact.getGroupId(), artifact.getArtifactId());
                    if (projectModules.contains(artifactAsProjectRef)) {
                        return;
                    }
                    try {
                        MavenArtifact channelArtifact = channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersion());
                        if (!artifact.getVersion().equals(channelArtifact.getVersion())) {
                            List unalignedArtifactsForModule = unalignedArtifacts.computeIfAbsent(module2, m -> new ArrayList());
                            unalignedArtifactsForModule.add(Pair.of((Object)artifact, (Object)channelArtifact));
                        }
                    }
                    catch (UnresolvedMavenArtifactException unresolvedMavenArtifactException) {
                        // empty catch block
                    }
                });
            }
            if (!unalignedArtifacts.isEmpty()) {
                unalignedArtifacts.forEach((module, list) -> list.forEach(pair -> {
                    Artifact a = (Artifact)pair.getLeft();
                    MavenArtifact channelArtifact = (MavenArtifact)pair.getRight();
                    this.getLog().error((CharSequence)String.format("Dependency %s:%s:%s on module %s:%s is not aligned to version %s", a.getGroupId(), a.getArtifactId(), a.getVersion(), module.getGroupId(), module.getArtifactId(), channelArtifact.getVersion()));
                }));
                throw new MojoFailureException("Some artifacts were not aligned. See above logs for details.");
            }
        }
        catch (DependencyCollectorBuilderException e) {
            throw new MojoExecutionException("Can't collect dependency graph", (Exception)((Object)e));
        }
        catch (ManipulationException e) {
            throw new MojoExecutionException("Can't parse project structure to PME representation", (Exception)((Object)e));
        }
    }

    private boolean isLegacyBom(MavenProject module) {
        return EAP_GROUPID.equals(module.getGroupId()) && LEGACY_BOM_ARTIFACTID.equals(module.getArtifactId());
    }

    private boolean dependsOnLegacyBom(MavenProject module) throws MojoExecutionException {
        if (EAP_GROUPID.equals(module.getGroupId()) && EAP_PARENT_ARTIFACTID.equals(module.getArtifactId())) {
            return false;
        }
        try {
            Optional<Project> pmeProject = this.pmeProjects.stream().filter(p -> p.getGroupId().equals(module.getGroupId()) && p.getArtifactId().equals(module.getArtifactId())).findFirst();
            if (pmeProject.isEmpty()) {
                throw new MojoExecutionException(String.format("Couldn't locate PME project for module %s:%s", module.getGroupId(), module.getArtifactId()));
            }
            Map managedDependencies = pmeProject.get().getResolvedManagedDependencies((MavenSessionHandler)this.manipulationSession);
            boolean dependsOnLegacyBom = managedDependencies.entrySet().stream().anyMatch(e -> EAP_GROUPID.equals(((ArtifactRef)e.getKey()).getGroupId()) && LEGACY_BOM_ARTIFACTID.equals(((ArtifactRef)e.getKey()).getArtifactId()) && "import".equals(((Dependency)e.getValue()).getScope()));
            return dependsOnLegacyBom || this.dependsOnLegacyBom(module.getParent());
        }
        catch (ManipulationException e2) {
            throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)e2));
        }
    }

    private ChannelSession createChannelSession() throws MojoExecutionException {
        try {
            Path channelFilePath = Path.of(this.channelFile, new String[0]);
            if (!channelFilePath.isAbsolute()) {
                channelFilePath = Path.of(this.mavenSession.getExecutionRootDirectory(), new String[0]).resolve(channelFilePath);
            }
            this.getLog().info((CharSequence)("Reading channel file " + channelFilePath));
            Channel channel = ChannelMapper.from((URL)channelFilePath.toUri().toURL());
            DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
            locator.addService(TransporterFactory.class, FileTransporterFactory.class);
            locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

                public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                    throw new RuntimeException("Failed to initiate maven repository system");
                }
            });
            RepositorySystem repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
            return new ChannelSession(Collections.singletonList(channel), (MavenVersionsResolver.Factory)new VersionResolverFactory(repositorySystem, this.mavenSession.getRepositorySession(), Collections.emptyList()));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not read channelFile", (Exception)e);
        }
    }
}

