/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import java.util.Iterator;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.junit.Assert;
import org.junit.Test;

public class MavenDependenciesTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void prohibitsNullCanonicalForm() {
        MavenDependencies.createDependency((String)null, (ScopeType)ScopeType.IMPORT, (boolean)true, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void prohibitsNullCoordinate() {
        MavenDependencies.createDependency((MavenCoordinate)null, (ScopeType)ScopeType.IMPORT, (boolean)true, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void prohibitsEmptyStringCanonicalForm() {
        MavenDependencies.createDependency((String)"", (ScopeType)ScopeType.IMPORT, (boolean)true, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
    }

    @Test(expected=CoordinateParseException.class)
    public void prohibitsIncorrectFormatCanonicalForm() {
        MavenDependencies.createDependency((String)"not-in-correct-format", (ScopeType)ScopeType.IMPORT, (boolean)true, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void prohibitsNullCanonicalFormForExclusion() {
        MavenDependencies.createExclusion(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void prohibitsEmptyStringCanonicalFormForExclusion() {
        MavenDependencies.createExclusion(null);
    }

    @Test(expected=CoordinateParseException.class)
    public void prohibitsIncorrectFormatCanonicalFormForExclusion() {
        MavenDependencies.createExclusion((String)"not-in-correct-format");
    }

    @Test
    public void createExclusion() {
        MavenDependencyExclusion exclusion = MavenDependencies.createExclusion((String)"groupId:artifactId");
        Assert.assertEquals((Object)"groupId", (Object)exclusion.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)exclusion.getArtifactId());
    }

    @Test
    public void createExclusionFromGroupIdAndArtifactId() {
        MavenDependencyExclusion exclusion = MavenDependencies.createExclusion((String)"groupId", (String)"artifactId");
        Assert.assertEquals((Object)"groupId", (Object)exclusion.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)exclusion.getArtifactId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void createExclusionNullGroupId() {
        MavenDependencies.createExclusion(null, (String)"artifactId");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createExclusionNullArtifactId() {
        MavenDependencies.createExclusion((String)"groupId", null);
    }

    @Test(expected=CoordinateParseException.class)
    public void createExclusionExtraProps() {
        MavenDependencies.createExclusion((String)"groupId:artifactId:shouldnBeHere");
    }

    @Test
    public void fullProperties() {
        MavenDependency dependency = MavenDependencies.createDependency((String)"groupId:artifactId:ear:classifier:version", (ScopeType)ScopeType.PROVIDED, (boolean)true, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
        Assert.assertEquals((Object)"groupId", (Object)dependency.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)dependency.getArtifactId());
        Assert.assertEquals((Object)PackagingType.EAR, (Object)dependency.getPackaging());
        Assert.assertEquals((Object)"classifier", (Object)dependency.getClassifier());
        Assert.assertEquals((Object)"version", (Object)dependency.getVersion());
        Assert.assertEquals((Object)ScopeType.PROVIDED, (Object)dependency.getScope());
        Assert.assertTrue((boolean)dependency.isOptional());
    }

    @Test
    public void fullPropertiesWithExclusions() {
        MavenDependencyExclusion exclusion1 = MavenDependencies.createExclusion((String)"group1:artifact1");
        MavenDependencyExclusion exclusion2 = MavenDependencies.createExclusion((String)"group2:artifact2");
        MavenDependency dependency = MavenDependencies.createDependency((String)"groupId:artifactId:ear:classifier:version", (ScopeType)ScopeType.PROVIDED, (boolean)true, (MavenDependencyExclusion[])new MavenDependencyExclusion[]{exclusion1, exclusion2});
        Assert.assertEquals((Object)"groupId", (Object)dependency.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)dependency.getArtifactId());
        Assert.assertEquals((Object)PackagingType.EAR, (Object)dependency.getPackaging());
        Assert.assertEquals((Object)"classifier", (Object)dependency.getClassifier());
        Assert.assertEquals((Object)"version", (Object)dependency.getVersion());
        Assert.assertEquals((Object)ScopeType.PROVIDED, (Object)dependency.getScope());
        Assert.assertTrue((boolean)dependency.isOptional());
        Set exclusions = dependency.getExclusions();
        Assert.assertEquals((long)2L, (long)exclusions.size());
        Iterator it = exclusions.iterator();
        MavenDependencyExclusion roundtrip1 = (MavenDependencyExclusion)it.next();
        Assert.assertEquals((Object)"group1", (Object)roundtrip1.getGroupId());
        Assert.assertEquals((Object)"artifact1", (Object)roundtrip1.getArtifactId());
        MavenDependencyExclusion roundtrip2 = (MavenDependencyExclusion)it.next();
        Assert.assertEquals((Object)"group2", (Object)roundtrip2.getGroupId());
        Assert.assertEquals((Object)"artifact2", (Object)roundtrip2.getArtifactId());
    }

    @Test
    public void nullExclusionsAdjustedToEmpySet() {
        MavenDependency dependency = MavenDependencies.createDependency((String)"groupId:artifactId:ear:classifier:version", (ScopeType)ScopeType.PROVIDED, (boolean)true, (MavenDependencyExclusion[])new MavenDependencyExclusion[]{null});
        Assert.assertEquals((long)0L, (long)dependency.getExclusions().size());
    }
}

