/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.shrinkwrap.resolver.api.maven;

import org.jboss.shrinkwrap.resolver.api.ResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.TransitiveStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;

/**
 * Provides support for Maven-based {@link ResolutionStrategy}s in artifact resolution
 *
 * @param <FORMATSTAGETYPE>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @author <a href="mailto:kpiwko@redhat.com">Karel Piwko</a>
 */
public interface MavenStrategyStageBase<STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
    extends TransitiveStrategyStage<MavenDependency, MavenResolutionFilter, MavenResolvedArtifact, FORMATSTAGETYPE, MavenResolutionStrategy> {

    /**
     * Sets that resolution from the ClassPath should be permitted in addition to configured repositories - defaults to
     * "true". This method is deprecated, because it does not influence setup of pom.xml resolution.
     *
     * Please use {@code Maven.configureResolver()} to get resolver with extended configuration and call
     * {@link ConfiguredMavenResolverSystemFactory#withClassPathResolution(boolean)} instead.
     *
     * @param useClassPathResolution
     * @return
     */
    @Deprecated
    STRATEGYSTAGETYPE withClassPathResolution(boolean useClassPathResolution);

    /**
     * Sets whether to consult the Maven Central Repository in resolution; defaults to true.
     * This method is deprecated, because it does not influence setup of pom.xml resolution.
     *
     * Please use {@code Maven.configureResolver()} to get resolver with extended configuration and call
     * {@link ConfiguredMavenResolverSystemFactory#withMavenCentralRepo(boolean)} instead.
     *
     * @param useMavenCentral
     * @return
     */
    @Deprecated
    STRATEGYSTAGETYPE withMavenCentralRepo(boolean useMavenCentral);
}
