/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinateImpl;
import org.junit.Assert;
import org.junit.Test;

public class MavenCoordinateImplTestCase {
    @Test
    public void equalsByValue() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate1 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenCoordinateImpl coordinate2 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        Assert.assertEquals((Object)coordinate1, (Object)coordinate2);
    }

    @Test
    public void notEqualsByGroupIdValue() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate1 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenCoordinateImpl coordinate2 = new MavenCoordinateImpl("wrong", "artifactId", "version", packaging, "classifier");
        Assert.assertFalse((boolean)coordinate1.equals((Object)coordinate2));
    }

    @Test
    public void notEqualsByArtifactIdValue() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate1 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenCoordinateImpl coordinate2 = new MavenCoordinateImpl("groupId", "wrong", "version", packaging, "classifier");
        Assert.assertFalse((boolean)coordinate1.equals((Object)coordinate2));
    }

    @Test
    public void equalsByValueWithDifferentVersions() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate1 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenCoordinateImpl coordinate2 = new MavenCoordinateImpl("groupId", "artifactId", null, packaging, "classifier");
        Assert.assertEquals((String)"Version should not be considered in value equality check", (Object)coordinate1, (Object)coordinate2);
    }

    @Test
    public void notEqualsByPackagingValue() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate1 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenCoordinateImpl coordinate2 = new MavenCoordinateImpl("groupId", "artifactId", "version", PackagingType.EAR, "classifier");
        Assert.assertFalse((boolean)coordinate1.equals((Object)coordinate2));
    }

    @Test
    public void notEqualsByClassifierValue() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate1 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenCoordinateImpl coordinate2 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "wrong");
        Assert.assertFalse((boolean)coordinate1.equals((Object)coordinate2));
    }

    @Test
    public void equalHashCodes() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate1 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenCoordinateImpl coordinate2 = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        Assert.assertTrue((coordinate1.hashCode() == coordinate2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void properties() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        Assert.assertEquals((Object)"groupId", (Object)coordinate.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)coordinate.getArtifactId());
        Assert.assertEquals((Object)"version", (Object)coordinate.getVersion());
        Assert.assertEquals((Object)packaging, (Object)coordinate.getPackaging());
        Assert.assertEquals((Object)"classifier", (Object)coordinate.getClassifier());
        Assert.assertEquals((Object)("groupId:artifactId:" + packaging.toString() + ":" + "classifier" + ":" + "version"), (Object)coordinate.toCanonicalForm());
    }

    @Test
    public void defaultPackagingType() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        String classifier = "classifier";
        MavenCoordinateImpl coordinate = new MavenCoordinateImpl("groupId", "artifactId", "version", null, "classifier");
        Assert.assertEquals((Object)PackagingType.JAR, (Object)coordinate.getPackaging());
    }

    @Test
    public void ejbPackaging() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        PackagingType packaging = PackagingType.of((String)"ejb");
        String version = "version";
        MavenCoordinateImpl coordinate = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, null);
        Assert.assertEquals((Object)PackagingType.EJB, (Object)coordinate.getPackaging());
        Assert.assertEquals((Object)"jar", (Object)coordinate.getPackaging().getExtension());
    }
}

