/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.junit.Assert;
import org.junit.Test;

public class MavenCoordinatesTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void prohibitsNull() {
        MavenCoordinates.createCoordinate(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void prohibitsEmptyString() {
        MavenCoordinates.createCoordinate((String)"");
    }

    @Test(expected=CoordinateParseException.class)
    public void incorrectFormat() {
        MavenCoordinates.createCoordinate((String)"not-in-correct-format");
    }

    @Test
    public void fullProperties() {
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)"groupId:artifactId:jar:classifier:version");
        Assert.assertEquals((Object)"groupId", (Object)coordinate.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)coordinate.getArtifactId());
        Assert.assertEquals((Object)PackagingType.JAR, (Object)coordinate.getPackaging());
        Assert.assertEquals((Object)"classifier", (Object)coordinate.getClassifier());
        Assert.assertEquals((Object)"version", (Object)coordinate.getVersion());
    }

    @Test
    public void unknownVersion() {
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)"groupId:artifactId");
        Assert.assertEquals((Object)"groupId", (Object)coordinate.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)coordinate.getArtifactId());
        Assert.assertEquals((Object)PackagingType.JAR, (Object)coordinate.getPackaging());
        Assert.assertEquals((Object)"", (Object)coordinate.getClassifier());
        Assert.assertNull((Object)coordinate.getVersion());
    }

    @Test
    public void unknownPackagingTypeAndClassifier() {
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)"groupId:artifactId:version");
        Assert.assertEquals((Object)"groupId", (Object)coordinate.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)coordinate.getArtifactId());
        Assert.assertEquals((Object)PackagingType.JAR, (Object)coordinate.getPackaging());
        Assert.assertEquals((Object)"", (Object)coordinate.getClassifier());
        Assert.assertEquals((Object)"version", (Object)coordinate.getVersion());
    }

    @Test
    public void unknownClassifier() {
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)"groupId:artifactId:ear:version");
        Assert.assertEquals((Object)"groupId", (Object)coordinate.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)coordinate.getArtifactId());
        Assert.assertEquals((Object)PackagingType.EAR, (Object)coordinate.getPackaging());
        Assert.assertEquals((Object)"", (Object)coordinate.getClassifier());
        Assert.assertEquals((Object)"version", (Object)coordinate.getVersion());
    }

    @Test
    public void blankPackagingType() {
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)"groupId:artifactId::classifier:version");
        Assert.assertEquals((Object)"groupId", (Object)coordinate.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)coordinate.getArtifactId());
        Assert.assertEquals((Object)PackagingType.JAR, (Object)coordinate.getPackaging());
        Assert.assertEquals((Object)"classifier", (Object)coordinate.getClassifier());
        Assert.assertEquals((Object)"version", (Object)coordinate.getVersion());
    }
}

