/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.gradle;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.impl.gradle.Gradle;
import org.junit.jupiter.api.Test;

class ShrinkWrapGradleTestCase {
    ShrinkWrapGradleTestCase() {
    }

    @Test
    void should_return_dependencies_by_scope_in_simple_build_script() {
        List archives = Gradle.resolver().forProjectDirectory("src/test/resources/simple").importCompileAndRuntime().resolve().asList(JavaArchive.class);
        Assertions.assertThat((List)archives).extracting("name").contains(new Object[]{"slf4j-simple-1.7.5.jar", "slf4j-api-1.7.5.jar"});
    }

    @Test
    void should_return_dependencies_by_scope_in_dependency_management_build_script() {
        List archives = Gradle.resolver().forProjectDirectory("src/test/resources/dependencymanager").importRuntime().resolve().asList(JavaArchive.class);
        Assertions.assertThat((List)archives).extracting("name").contains(new Object[]{"deltaspike-core-impl-1.7.1.jar"});
    }

    @Test
    void should_skip_non_zip_files_in_depchain_build_script() {
        List archives = Gradle.resolver().forProjectDirectory("src/test/resources/depchain").importCompileAndRuntime().resolve().asList(JavaArchive.class);
        Assertions.assertThat((List)archives).extracting("name").doesNotContain(new Object[]{"shrinkwrap-resolver-depchain-2.2.6.pom"});
    }
}

