/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class BuiltProjectImpl
implements BuiltProject {
    private File pom;
    private File globalSettingsXml;
    private File userSettingsXml;
    private String[] profiles;
    private Model model;
    private String mavenLog;
    private int mavenBuildExitCode = 0;
    private Properties properties;

    public BuiltProjectImpl(String pom, String ... profiles) {
        this(new File(pom), (File)null, (File)null, (Properties)null, profiles);
    }

    public BuiltProjectImpl(File pom, String ... profiles) {
        this(pom, (File)null, (File)null, (Properties)null, profiles);
    }

    public BuiltProjectImpl(String pom, File globalSettingsXml, File userSettingsXml, Properties properties, String ... profiles) {
        this(new File(pom), globalSettingsXml, userSettingsXml, properties, profiles);
    }

    public BuiltProjectImpl(File pom, File globalSettingsXml, File userSettingsXml, Properties properties, String ... profiles) {
        this.pom = pom;
        this.profiles = profiles;
        this.globalSettingsXml = globalSettingsXml;
        this.userSettingsXml = userSettingsXml;
        this.properties = properties;
    }

    public Model getModel() {
        if (this.model == null) {
            MavenWorkingSessionImpl mavenWorkingSession = new MavenWorkingSessionImpl();
            mavenWorkingSession.configureSettingsFromFile(this.globalSettingsXml, this.userSettingsXml);
            ParsedPomFile parsedPomFile = mavenWorkingSession.loadPomFromFile(this.pom, this.properties, this.profiles).getParsedPomFile();
            this.model = parsedPomFile.getModel();
        }
        return this.model;
    }

    public Archive getDefaultBuiltArchive() {
        String finalName = this.getModel().getBuild().getFinalName();
        String buildDirectory = this.getModel().getBuild().getDirectory();
        String packaging = this.getModel().getPackaging();
        PackagingType packagingType = PackagingType.fromCache((String)packaging);
        if (packagingType == null) {
            throw new IllegalArgumentException("The packaging type " + packaging + " is not supported");
        }
        if (packagingType != PackagingType.POM) {
            File zipFile = new File(buildDirectory + File.separator + finalName + "." + packaging);
            return (Archive)ShrinkWrap.createFromZipFile(this.getArchiveRepresentation(packagingType), (File)zipFile);
        }
        return null;
    }

    private Class<? extends Archive> getArchiveRepresentation(PackagingType packagingType) {
        if (packagingType == PackagingType.EAR) {
            return EnterpriseArchive.class;
        }
        if (packagingType == PackagingType.WAR) {
            return WebArchive.class;
        }
        return JavaArchive.class;
    }

    public BuiltProject getModule(String moduleName) {
        List modules = this.getModel().getModules();
        File projectDirectory = this.getModel().getProjectDirectory();
        for (String module : modules) {
            if (!moduleName.equals(module)) continue;
            return this.getSubmodule(projectDirectory + File.separator + module + File.separator + "pom.xml");
        }
        return null;
    }

    public List<BuiltProject> getModules() {
        List modules = this.getModel().getModules();
        File projectDirectory = this.getModel().getProjectDirectory();
        ArrayList<BuiltProject> projects = new ArrayList<BuiltProject>(modules.size());
        for (String module : modules) {
            projects.add(this.getSubmodule(projectDirectory + File.separator + module + File.separator + "pom.xml"));
        }
        return projects;
    }

    private BuiltProject getSubmodule(String pomfile) {
        BuiltProjectImpl submodule = new BuiltProjectImpl(pomfile, this.globalSettingsXml, this.userSettingsXml, this.properties, this.profiles);
        submodule.setMavenBuildExitCode(this.getMavenBuildExitCode());
        submodule.setMavenLog(this.getMavenLog());
        return submodule;
    }

    public File getTargetDirectory() {
        if (this.getModel().getBuild() == null) {
            return null;
        }
        return new File(this.getModel().getBuild().getDirectory());
    }

    public List<Archive> getArchives() {
        File[] allFirstLevelFiles = this.getFirstLevelFiles();
        if (allFirstLevelFiles == null) {
            return null;
        }
        ArrayList<Archive> archives = new ArrayList<Archive>(allFirstLevelFiles.length);
        for (File file : allFirstLevelFiles) {
            Class<? extends Archive> archiveType = this.getIfSupported(file);
            if (archiveType == null) continue;
            archives.add((Archive)ShrinkWrap.createFromZipFile(archiveType, (File)file));
        }
        return archives;
    }

    private File[] getFirstLevelFiles() {
        File targetDirectory = this.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        return targetDirectory.listFiles();
    }

    private Class<? extends Archive> getIfSupported(File file) {
        PackagingType packagingType;
        String extension = FilenameUtils.getExtension((String)file.getName());
        if (!Validate.isNullOrEmpty((String)extension) && (packagingType = PackagingType.fromCache((String)extension)) != null && packagingType != PackagingType.POM) {
            return this.getArchiveRepresentation(packagingType);
        }
        return null;
    }

    public <A extends Archive<?>> List<A> getArchives(Class<A> type) {
        File[] allFirstLevelFiles = this.getFirstLevelFiles();
        if (allFirstLevelFiles == null) {
            return null;
        }
        ArrayList<Assignable> archives = new ArrayList<Assignable>();
        for (File file : allFirstLevelFiles) {
            Class<? extends Archive> archiveType = this.getIfSupported(file);
            if (archiveType == null || !archiveType.isAssignableFrom(type)) continue;
            archives.add(ShrinkWrap.createFromZipFile(type, (File)file));
        }
        return archives;
    }

    public String getMavenLog() {
        return this.mavenLog;
    }

    public void setMavenLog(String mavenLog) {
        this.mavenLog = mavenLog;
    }

    public int getMavenBuildExitCode() {
        return this.mavenBuildExitCode;
    }

    public void setMavenBuildExitCode(int mavenBuildExitCode) {
        this.mavenBuildExitCode = mavenBuildExitCode;
    }
}

