/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.jboss.shrinkwrap.resolver.impl.maven.LogRepositoryListener;
import org.jboss.shrinkwrap.resolver.impl.maven.LogTransferListerer;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverSettings;
import org.jboss.shrinkwrap.resolver.impl.maven.Validate;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;

public class MavenManagerBuilder {
    private MavenDependencyResolverSettings settings;
    private RepositorySystem system;

    public MavenManagerBuilder(RepositorySystem system, MavenDependencyResolverSettings settings) {
        this.system = system;
        this.settings = settings;
    }

    public TransferListener transferListerer() {
        return new LogTransferListerer();
    }

    public RepositoryListener repositoryListener() {
        return new LogRepositoryListener();
    }

    public LocalRepositoryManager localRepositoryManager() {
        String localRepositoryPath = this.settings.getSettings().getLocalRepository();
        Validate.notNullOrEmpty(localRepositoryPath, "Path to a local repository must be defined");
        LocalRepositoryType repositoryType = this.settings.isOffline() ? LocalRepositoryType.SIMPLE : LocalRepositoryType.ENHANCED;
        return this.system.newLocalRepositoryManager(new LocalRepository(new File(localRepositoryPath), repositoryType.contentType()));
    }

    public MirrorSelector mirrorSelector() {
        DefaultMirrorSelector dms = new DefaultMirrorSelector();
        for (Mirror mirror : this.settings.getSettings().getMirrors()) {
            dms.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return dms;
    }

    public ProxySelector proxySelector() {
        DefaultProxySelector dps = new DefaultProxySelector();
        for (Proxy proxy : this.settings.getSettings().getProxies()) {
            dps.add(MavenConverter.asProxy(proxy), proxy.getNonProxyHosts());
        }
        return dps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LocalRepositoryType {
        SIMPLE("simple"),
        ENHANCED("enhanced");

        private final String type;

        private LocalRepositoryType(String type) {
            this.type = type;
        }

        public String contentType() {
            return this.type;
        }
    }
}

