/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;

class MavenDependencyImpl
implements MavenDependency {
    private String groupId;
    private String artifactId;
    private String version = "?";
    private String type = "jar";
    private String classifier = "";
    private String scope = "";
    private boolean optional = false;
    private List<String> exclusions = new ArrayList<String>();

    public MavenDependency setCoordinates(String coordinates) {
        MavenDependencyImpl dependency = MavenConverter.asDependency(coordinates);
        dependency.addExclusions(this.getExclusions());
        dependency.setOptional(this.isOptional());
        dependency.setScope(this.getScope());
        return dependency;
    }

    public String getScope() {
        return this.scope;
    }

    public MavenDependency setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public MavenDependency setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public String[] getExclusions() {
        return this.exclusions.toArray(new String[0]);
    }

    public String getCoordinates() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId);
        sb.append(":").append(this.artifactId);
        sb.append(":").append(this.type);
        if (this.classifier != null && this.classifier.length() != 0) {
            sb.append(":").append(this.classifier);
        }
        sb.append(":").append(this.version);
        return sb.toString();
    }

    public MavenDependency addExclusions(String ... exclusions) {
        if (exclusions.length == 0) {
            return this;
        }
        this.exclusions.addAll(Arrays.asList(exclusions));
        return this;
    }

    public boolean hasSameArtifactAs(MavenDependency other) {
        return this.equals(other);
    }

    public boolean hasSameArtifactAs(String other) {
        return this.equals(MavenConverter.asDependency(other));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenDependencyImpl other = (MavenDependencyImpl)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version = version == null || version.length() == 0 ? "?" : version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type = type == null || type.length() == 0 ? "jar" : type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier = classifier == null || classifier.length() == 0 ? "" : classifier;
    }

    public String toString() {
        return this.getCoordinates();
    }
}

