/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class MavenSettingsBuilder {
    public static final String ALT_USER_SETTINGS_XML_LOCATION = "org.apache.maven.user-settings";
    public static final String ALT_GLOBAL_SETTINGS_XML_LOCATION = "org.apache.maven.global-settings";
    public static final String ALT_MAVEN_OFFLINE = "org.apache.maven.offline";
    public static final String ALT_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";
    private static final String DEFAULT_USER_SETTINGS_PATH = SecurityActions.getProperty("user.home").concat("/.m2/settings.xml");
    private static final String DEFAULT_REPOSITORY_PATH = SecurityActions.getProperty("user.home").concat("/.m2/repository");

    public Settings buildDefaultSettings() {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String altUserSettings = SecurityActions.getProperty(ALT_USER_SETTINGS_XML_LOCATION);
        String altGlobalSettings = SecurityActions.getProperty(ALT_GLOBAL_SETTINGS_XML_LOCATION);
        request.setUserSettingsFile(new File(DEFAULT_USER_SETTINGS_PATH));
        if (altUserSettings != null && altUserSettings.length() > 0) {
            request.setUserSettingsFile(new File(altUserSettings));
        }
        if (altGlobalSettings != null && altGlobalSettings.length() > 0) {
            request.setGlobalSettingsFile(new File(altGlobalSettings));
        }
        return this.buildSettings((SettingsBuildingRequest)request);
    }

    public Settings buildSettings(File file) {
        Validate.notNull(file, "Settings file should not be null");
        Validate.isReadable(file.getAbsolutePath(), "Settings file '" + file.getAbsolutePath() + "' could not be read");
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(file);
        return this.buildSettings((SettingsBuildingRequest)request);
    }

    private Settings buildSettings(SettingsBuildingRequest request) {
        SettingsBuildingResult result;
        try {
            DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
            result = builder.build(request);
        }
        catch (SettingsBuildingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse Maven configuration", e);
        }
        Settings settings = result.getEffectiveSettings();
        if (settings.getLocalRepository() == null) {
            settings = this.enrichWithLocalRepository(settings);
        }
        return this.enrichWithOfflineMode(settings);
    }

    private Settings enrichWithLocalRepository(Settings settings) {
        String altLocalRepository = SecurityActions.getProperty(ALT_LOCAL_REPOSITORY_LOCATION);
        settings.setLocalRepository(DEFAULT_REPOSITORY_PATH);
        if (altLocalRepository != null && altLocalRepository.length() > 0) {
            settings.setLocalRepository(altLocalRepository);
        }
        return settings;
    }

    private Settings enrichWithOfflineMode(Settings settings) {
        String goOffline = SecurityActions.getProperty(ALT_MAVEN_OFFLINE);
        if (goOffline != null) {
            settings.setOffline(Boolean.valueOf(goOffline).booleanValue());
        }
        return settings;
    }
}

